#!/usr/bin/perl
use strict;
require 5.003;
use accutil;

my $version = '3.03';

print "Content-type: text/html\n\n";

my $cfgfile = accutil::cfgfile();
my $debug = 0;
my $LOCK_EX;
my %VARS;
my $accid = $ENV{'REMOTE_USER'};
if ($accid eq undef) {
  print "<b>Please the autoban.cgi run from password protected directory!</b>";
  exit;
}
if (!loadcfg()) {
  print "<b>autoban.cgi: Fatal error - failed to read congiguration file</b>";
  exit;
}
logit();
exit;

#==========================================================================logit
# $VARS{'maxip'} defines max number of unique IP addresses per 24 hours allowed
# if undef - no limits, uses accutil::autoban($accid) to disable account.
# Log file location: <basedir>/logit/$accid.txt
# Log file format:
# time:ip
# each IP is unique, entries older than 30 days must be deleted.

sub logit {
 my %hash;
 my $ctime = time;
 my $ips   = 0;

 mkdir("$VARS{basedir}/logit",0777) if(!-d "$VARS{basedir}/logit");

  if(!-e "$VARS{basedir}/logit/$accid.txt") { return undef if(!open(IPLOG,">$VARS{basedir}/logit/$accid.txt")); }
  else { return undef if(!open(IPLOG,"+<$VARS{basedir}/logit/$accid.txt")); seek(IPLOG,0,0); }
 flock(IPLOG,$LOCK_EX) if($LOCK_EX);
 my @lines = <IPLOG>;
 chomp(@lines);
 truncate(IPLOG,0);
 seek(IPLOG,0,0);
  for(@lines)
  {
   my($time,$ip) = split(/:/);
   $hash{$ip}    = $time;
  }
 $hash{$ENV{REMOTE_ADDR}} = $ctime;
  for(keys %hash)
  {
   $ips ++                      if($hash{$_} > $ctime - 24*60*60);
   delete $hash{$_}             if($hash{$_} < $ctime - 30*24*60*60);
   print IPLOG "$hash{$_}:$_\n" if(exists $hash{$_});
  }
  if($VARS{maxip} > 0 && $ips > $VARS{maxip})
  {
   accutil::autoban($accid);
  }

 close(IPLOG);
}
#======================================================================= loadcgf

sub loadcfg {
  if (! open(CFG, $cfgfile)) { return 0; }
  my @buff = <CFG>;
  close(CFG);
  chomp(@buff);
  foreach my $line (@buff) {
    my ($name, $value) = split(/=/, $line);
    if ($value ne undef) { $VARS{$name} = $value; }
  }
  accutil::init(%VARS);
  if ($VARS{'uselock'} ne undef) { $LOCK_EX = "2"; }
  return 1;
}