#!/usr/bin/perl
use strict;
require 5.003;
use accutil;
print "Content-type: text/html\n\n";

my $version = '3.04';
my $package = "Lite";
my $debug = 0;

my %VARS;
my %INPUT;
my %USRPWD;
my %USRMODE;
my %USRSID;
my %USRMAIL;
my %USRPHONE;
my %USRNAME;
my @demousers = ('demo');
my $cfgfile = accutil::cfgfile();
my $htpasswd = accutil::htpasswd();
my $htaccess = accutil::htaccess();
my $sidsubdir = accutil::sidsubdir();
my $cgidir;
my $sid;

my $pwdfile;
my $basedir;
my $adminemail;
my $mailer;
my $LOCK_EX;
my $htpasswddir;
my $hostaddr;
my ($mbrdir, $mbrurl);
my $scriptfilename;

my $cmpladdr;
my $reqemail;
my $uselock;
my $user;
my $logdir;
my $siddir;
my $cmd;
my $cgiurl = $ENV{'SCRIPT_NAME'};
my $accmgrpl;
my $adminpl = $cgiurl;
my $buffer;
my ($payemail, $payname);


my @pairs = split(/&/, $ENV{'QUERY_STRING'});
read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = (@pairs, split(/&/, $buffer));
foreach my $pair (@pairs) {
        my ($name, $value) = split(/=/, $pair);
        $value =~ s/%0D%0A/ /g;
        $value =~ s/%0A%0D/ /g;
        $value =~ tr/+/ /;
        $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
        if ($INPUT{$name}) { $INPUT{$name} = $INPUT{$name}.",".$value; }
        else { $INPUT{$name} = $value; }
}

$cmd = $INPUT{'cmd'};
$user = $INPUT{'user'};
srand(time());

findcgidir();

if ($cmd eq 'savecfg') {
  savecfg();
  exit;
}
if (!loadcfg()) { setup(); exit; }
$sid = $INPUT{'sid'};
if ($cmd eq 'login') { admlogin(); exit; }
if (!$sid) { admloginform(); exit; }
if ($VARS{'singleuser'} eq 'on' && $USRMODE{$user} ne 'A') { formshotdown(); exit; }
if (!checkadmsid()) { admloginform(); exit; }
if ($cmd eq 'singleuser') {
  if ($USRMODE{$user} eq 'A') { $VARS{'singleuser'} = 'on'; updatecfg(); }
  mainform();
  exit;
}
if ($cmd eq 'multiuser') {
  if ($USRMODE{$user} eq 'A') { $VARS{'singleuser'} = undef; updatecfg(); }
  mainform();
  exit;
}
if ($cmd eq 'upgrade') {
  if ($USRMODE{$user} eq 'A') { upgrade(); }
  exit;
}
if ($cmd eq 'pwdupd') { pwdupd(); exit; }
if ($user eq $USRPWD{$user}) { formpwd(); exit; }
if ($cmd eq 'syssetup') {
  if ($USRMODE{$user} ne 'A') { mainform(); } else { setup(); }
  exit;
}
if ($cmd eq 'usrmgm') { &usrmgm; exit; }
if ($cmd eq 'addusr') { &addusr; exit; }
if ($INPUT{'cmdadmin.x'} ne undef) { &mainform; exit; }
if ($cmd eq 'gomain') { &mainform; exit; }
if ($cmd eq 'usredit') {
  if ($INPUT{'cmdedit'}) { &formusredit; }
  elsif ($INPUT{'cmddel'}) { &formusrdel; }
  else { &mainform; }
  exit;
}
if ($cmd eq 'usrupd') { &usrupd; exit; }
if ($cmd eq 'logout') { &logout; exit; }
if ($cmd eq 'formpwd') { &formpwd; exit; }
if ($cmd eq 'usrdel') { &usrdel; exit; }

&header;
&formgomain;
&formlogout;
&footer;
exit;

#======================================================================== usrdel

sub usrdel {
  my $usrid = $INPUT{'usrid'};
  if (!$USRPWD{$usrid}) {
    &header;
    print "<br><b>Error: User $usrid does not exist</b><br>";
    &formgomain;
    &footer;
    return;
  }
  if ($USRMODE{$user} ne 'A' && $USRMODE{$user} ne 'S') {
    if ($user ne $usrid) {
      &header;
      print "<br><b>Error: You do not have permissions to delete users</b><br>";
      &formgomain;
      &footer;
      return;
    }
  }
  if ($USRMODE{$usrid} eq 'A') {
    &header;
    print "<br><b>Error: Sysadmin may not be deleted</b><br>";
    &formgomain;
    &footer;
    return;
  }
  if ($VARS{'demo'} ne undef) {
    my $id;
    foreach $id (@demousers) {
      if ($id eq $usrid) { usrmgm("Error: This user can't be deleted while in Basic demo"); return; }
    }
  }
  delete $USRPWD{$usrid};
  &savepwd;
  usrmgm("User $usrid deleted");
}

#============================================================================ pwdupd

sub pwdupd {
  my $usrid = $INPUT{'usrid'};
  my $pwd = $INPUT{'passwd'};
  my $newpwd = $INPUT{'newpwd'};
  my $newpwd1 = $INPUT{'newpwd1'};
  if ($pwd ne $USRPWD{$user}) {
    formpwd("Error: Wrong password, please go back and re-enter");
    return;
  }
  if ($USRMODE{$user} ne 'A' && $USRMODE{$user} ne 'S') {
    if ($user ne $usrid) {
      formpwd("Error: You do not have permissions to change passwords");
      return;
    }
  }
  if ($USRMODE{$usrid} eq 'A' && $usrid ne $user) {
    formpwd("Error: You do not have permissions to change sysadmin passwords");
    return;
  }
  if (!$newpwd) {
    formpwd("Error: No new password");
    return;
  }
  if (length($newpwd) < 6) {
    formpwd("Error: Password must be 6 characters or longer");
    return;
  }
  if ($newpwd eq $usrid) {
    formpwd("Error: Password may not be the same as user ID");
    return;
  }
  if ($newpwd =~ /\W/) {
    formpwd("Error: Password may contain alphanumeric characters only");
    return;
  }
  if ($newpwd ne $newpwd1) {
    formpwd("Error: Passwords do not match");
    return;
  }
  if ($VARS{'demo'} ne undef) {
    my $id;
    foreach $id (@demousers) {
      if ($id eq $usrid) { mainform("Error: This user can't be changed while in Demo Mode"); return; }
    }
  }
  $USRPWD{$usrid} = $newpwd;
  &savepwd;
  mainform("New password for user $usrid saved");
}


#============================================================================ formpwd

sub formpwd {
  my $msg = $_[0];
  if ($msg ne undef) { $msg = "<font color=\"red\"><b>$msg</b><br><br></font>"; }
  my $usrid = $INPUT{'usrid'};
  my $p;
  &header;
  if ($usrid eq undef && $user eq $USRPWD{$user}) {
    print "<font size=+1 color=red><b>Your password match your user ID. You must change your password</b></font><p>\n";
    $usrid = $user;
    $p = $user;
  }
print <<EOT;
<br><b>Changing password for user <font color="red">$usrid</font></b><p>$msg
<table border=0><tr><td>
<form method="POST" action="$cgiurl">
<input type="hidden" name="cmd" value="pwdupd">
<input type="hidden" name="sid" value="$sid">
<input type="hidden" name="user" value="$user">
<input type="hidden" name="usrid" value="$usrid">
Current password:</td><td><input type="password" size="10" name="passwd" value="$p";></td></tr>
<tr><td>New password:</td><td><input type="password" size="10" name="newpwd"></td></tr>
<tr><td>Re-enter new password:</td><td><input type="password" size="10" name="newpwd1"></td>
</table><br>
<input type="submit" value="Set password"></form><p>
EOT
  &formgomain;
  &formlogout;
  &footer;
}
#============================================================================ formlogin

sub formlogin {
print <<EOT;
<table><tr><td>
<form method="POST" action="$cgiurl">
<b>User:</b></td><td><input type="text" size="10" name="user"></td></tr>
<td><b>Password:</td><td><input type="password" size="10" name="passwd"></td></tr>
<tr><td><input type="hidden" name="cmd" value="login"></td><td>
<input type="submit" value="Login">
</form></td></tr></table>
EOT
}
#============================================================================ logout

sub logout {
  &header;
  $USRSID{$user} = 1.5;
  &savepwd;
  print "<center><b>You are logged out.</b><p>";
  &formlogin;
  print "</center>";
  &footer;
}

#============================================================================ usrupd

sub usrupd {
  my $usrid = $INPUT{'usrid'};
  my $newmd = $INPUT{'usrmode'};
  if (!$USRPWD{$usrid}) {
    mainform("Error: User $usrid does not exist");
    return;
  }
  if ($USRMODE{$user} ne 'A' && $USRMODE{$user} ne 'S') {
    if ($user ne $usrid) {
      mainform("Error: You do not have permissions to modify user info");
      return;
    }
  }
  if ($VARS{'demo'} ne undef) {
    my $id;
    foreach $id (@demousers) {
      if ($id eq $usrid) { usrmgm("Error: This user can't be changed while in Demo Mode"); return; }
    }
  }
  $USRNAME{$usrid} = $INPUT{'usrname'};
  $USRNAME{$usrid} =~ s/:/ /g;
  $USRMAIL{$usrid} = $INPUT{'usrmail'};
  $USRMAIL{$usrid} =~ s/:/ /g;
  $USRPHONE{$usrid} = $INPUT{'usrphone'};
  $USRPHONE{$usrid} =~ s/:/ /g;
  if ($USRMODE{$user} eq 'A' || $USRMODE{$user} eq 'S') {
    if ($newmd ne 'A' && $USRMODE{$usrid} ne 'A') { $USRMODE{$usrid} = $newmd; }
  }
  &savepwd;
  usrmgm("User $usrid updated");
}

#============================================================================ formusredit

sub formusredit {
  &header;
  my $usrid = $INPUT{'usrid'};
  if (!$USRPWD{$usrid}) {
    print "<br><b>Error: User $usrid does not exist</b><br>";
    &formgomain;
    &footer;
    return;
  }
  if ($USRMODE{$user} ne 'A' && $USRMODE{$user} ne 'S') {
    if ($user ne $usrid) {
      print "<br><b>Error: You do not have permissions to edit users</b><br>";
      &formgomain;
      &footer;
      return;
    }
  }
  if ($USRMODE{$user} ne 'A' && $USRMODE{$usrid} eq 'A') {
    print "<br><b>Error: You do not have permissions to edit sysadmin</b><br>";
    &formgomain;
    &footer;
    return;
  }
  my $selmode;
  my $usrmd = $USRMODE{$usrid};
  if ($usrmd ne 'A' && ($USRMODE{$user} eq 'A' || $USRMODE{$user} eq 'S')) {
    $selmode = "<tr><td>Access Rights:</td><td><select name=\"usrmode\">";
    $selmode = $selmode . "<option value=\"S\"";
    if ($usrmd eq 'S') { $selmode = $selmode . " selected"; }
    $selmode = $selmode . ">Supervisor<option value=\"B\"";
    if ($usrmd eq 'B') { $selmode = $selmode . " selected"; }
    $selmode = $selmode . ">Bookkeeper<option value=\"O\"";
    if ($usrmd eq 'O') { $selmode = $selmode . " selected"; }
    $selmode = $selmode . ">Operator</select></td></tr>";
  }
  my $usrnm = $USRNAME{$usrid};
  $usrnm =~ s/\"/&quot;/g;
print <<EOT;
User <b>$usrid</b><p>
<table border=0><tr><td>
<form method="POST" action="$cgiurl">
<input type="hidden" name="cmd" value="usrupd">
<input type="hidden" name="sid" value="$sid">
<input type="hidden" name="user" value="$user">
<input type="hidden" name="usrid" value="$usrid">
Name:</td><td><input type="text" size="25" name="usrname" value="$usrnm"></td></tr>
<tr><td>Email:</td><td><input type="text" size="25" name="usrmail" value="$USRMAIL{$usrid}"></td></tr>
<tr><td>Phone:</td><td><input type="text" size="25" name="usrphone" value="$USRPHONE{$usrid}"></td>
$selmode
</table><br>
<input type="submit" value="Update user info"></form><p>
<form method="POST" action="$cgiurl">
<input type="hidden" name="cmd" value="formpwd">
<input type="hidden" name="sid" value="$sid">
<input type="hidden" name="user" value="$user">
<input type="hidden" name="usrid" value="$usrid">
<input type="submit" value="Change password for $usrid"></form><p>
EOT
&formgomain;
&formlogout;
&footer;
}

#============================================================================ formusrdel

sub formusrdel {
  &header;
  my $usrid = $INPUT{'usrid'};
  if (!$USRPWD{$usrid}) {
    print "<br><b>Error: User $usrid does not exist</b><br>";
    &formgomain;
    &footer;
    return;
  }
  if ($USRMODE{$user} ne 'A' && $USRMODE{$user} ne 'S') {
    if ($user ne $usrid) {
      print "<br><b>Error: You do not have permissions to delete users</b><br>";
      &formgomain;
      &footer;
      return;
    }
  }
  if ($USRMODE{$usrid} eq 'A') {
    print "<br><b>Error: Sysadmin may not be deleted</b><br>";
    &formgomain;
    &footer;
    return;
  }
print <<EOT;
<font color=red size=+1><b>Deleting user $usrid [$USRNAME{$usrid}]</b></font><p>
<form method="POST" action="$cgiurl">
<input type="hidden" name="cmd" value="usrdel">
<input type="hidden" name="sid" value="$sid">
<input type="hidden" name="user" value="$user">
<input type="hidden" name="usrid" value="$usrid">
<b>Are you sure?</b> &nbsp;&nbsp;<input type="submit" value="Yes, delete user $usrid">
</form>
<form method="POST" action="$cgiurl">
<input type="hidden" name="cmd" value="gomain">
<input type="hidden" name="sid" value="$sid">
<input type="hidden" name="user" value="$user">
<input type="submit" value="Cancel">
</form>
EOT
  &footer;
}
#============================================================================ formaccmgr

sub formaccmgr {
print <<EOT;
  <form method="POST" action="$accmgrpl">
  <input type="hidden" name="cmd" value="gomain">
  <input type="hidden" name="sid" value="$sid">
  <input type="hidden" name="user" value="$user">
  <input type="submit" value="Account Manager">
  </form>
EOT
}
#============================================================================ formgomain

sub formgomain {
print <<EOT;
  <form method="POST" action="$cgiurl">
  <input type="hidden" name="cmd" value="gomain">
  <input type="hidden" name="sid" value="$sid">
  <input type="hidden" name="user" value="$user">
  <input type="submit" value="Go to main menu">
  </form>
EOT
}
#============================================================================ formlogout

sub formlogout {
print <<EOT;
  <form method="POST" action="$cgiurl">
  <input type="hidden" name="cmd" value="logout">
  <input type="hidden" name="sid" value="$sid">
  <input type="hidden" name="user" value="$user">
  <input type="submit" value="Logoff">
  </form>
EOT
}
#============================================================================ addusr

sub addusr {
  my $usrid = $INPUT{'usrid'};
  if ($USRMODE{$user} ne 'A' && $USRMODE{$user} ne 'S') { usrmgm(); return; }
  if ($INPUT{'usrmode'} eq 'A') { usrmgm(); return; }
  if (!$usrid) {
    usrmgm("Missing User ID");
    return;
  }
  if ($USRMODE{$usrid} ne undef) {
    usrmgm("User $usrid already exists");
    return;
  }
  $USRPWD{$usrid} = $usrid;
  $USRMODE{$usrid} = $INPUT{'usrmode'};
  $USRSID{$usrid} = 0;
  $USRMAIL{$usrid} = $INPUT{'usrmail'};
  $USRPHONE{$usrid} = $INPUT{'usrphone'};
  $USRNAME{$usrid} = $INPUT{'usrname'};
  &savepwd;
  usrmgm("Created user $usrid, password set to $usrid. User will be prompted to change password");
}
#============================================================================ usrmgm

sub usrmgm {
  my $msg = $_[0];
  if ($USRMODE{$user} ne 'A' && $USRMODE{$user} ne 'S') { mainform($msg); return; }
  if ($msg ne undef) { $msg = "<font color=\"red\"><b>$msg</b><br><br></font>"; }
  &header;
  print "<center><b>User Management</b><br><br>$msg\n";
  print "<table border=\"1\" CELLSPACING=\"0\" cellpadding=\"3\" width=\"760\" valign=\"top\"><tr><td><b>User ID</b></td><td><b>Name</b></td><td><b>Email</b></td><td><b>Phone</b></td><td><b>Rights</b></td><td><b>Action</b></td><tr>\n";
  my @names = sort keys(%USRPWD);
  my $name;
  foreach $name (@names) {
print <<EOT;
<tr><td>
<form method="POST" action="$cgiurl">
<input type="hidden" name="cmd" value="usredit">
<input type="hidden" name="sid" value="$sid">
<input type="hidden" name="user" value="$user">
<input type="hidden" name="usrid" value="$name">
EOT
    print "$name</td>";
    my $str=$USRNAME{$name};
    $str = "&nbsp;" if $str eq undef;
    print "<td>$str</td>";
    if ($USRMAIL{$name} ne undef) { $str = "<a href=\"mailto:$USRMAIL{$name}\">$USRMAIL{$name}</a>"; }
    else { $str = "&nbsp;"; }
    print "<td>$str</td>";
    $str=$USRPHONE{$name};
    $str = "&nbsp;" if $str eq undef;
    print "<td>$str</td><td>";
    my $r = $USRMODE{$name};
    if ($r eq 'A') { print "Sysadmin"; }
    elsif ($r eq 'S') { print "Supervisor"; }
    elsif ($r eq 'B') { print "Bookkeeper"; }
    elsif ($r eq 'O') { print "Operator"; }
    print  "</td><td>";
    if ($USRMODE{$name} eq 'A') {
      if ($USRMODE{$user} eq 'A') {
        print "<input type=\"submit\" name=\"cmdedit\" value=\"Edit\">";
      } else {
        print "<center>*</center>";
      }
    } else {
      print "<input type=\"submit\" name=\"cmdedit\" value=\"Edit\">";
      print "<input type=\"submit\" name=\"cmddel\" value=\"Delete\">";
    }
    print "</td></form></tr>\n";
  }
print <<EOT;
<tr><td>
<form method="POST" action="$cgiurl">
<input type="hidden" name="cmd" value="addusr">
<input type="hidden" name="sid" value="$sid">
<input type="hidden" name="user" value="$user">
<input type="text" size="8" name="usrid"></td>
<td><input type="text" size="20" name="usrname"></td>
<td><input type="text" size="20" name="usrmail"></td>
<td><input type="text" size="15" name="usrphone"></td>
<td><SELECT NAME="usrmode">
<OPTION value="S">Supervisor
<OPTION value="B">Bookkeeper
<OPTION value="O" selected>Operator
</SELECT></td><td>
<input type="submit" value="Add user"></td></form></tr></table>
EOT
  &formgomain;
  &formlogout;
  print "</center>";
  &footer;
}
#============================================================================ checkadmsid

sub checkadmsid {
  if ($sid eq $USRSID{$user}) { return 1; }
  return 0;
}
#============================================================================ mainform

sub mainform {
  &header;
  my $msg = $_[0];
  if ($msg ne undef) { $msg = "<font color=\"red\"><b>$msg</b><br><br></font>"; }
  print "<center><br><b>Main Menu</b><br><br>$msg";
  if ($USRMODE{$user} eq 'A') {
    if ($VARS{'singleuser'} eq 'on') {
print <<EOT;
<form method="POST" action="$cgiurl">
<input type="hidden" name="cmd" value="multiuser">
<input type="hidden" name="sid" value="$sid">
<input type="hidden" name="user" value="$user">
<input type="submit" value="Switch to multiuser mode">
</form>
EOT
    } else {
print <<EOT;
<form method="POST" action="$cgiurl">
<input type="hidden" name="cmd" value="singleuser">
<input type="hidden" name="sid" value="$sid">
<input type="hidden" name="user" value="$user">
<input type="submit" value="Shut down databases">
</form>
EOT
    }
    if ($version gt $VARS{'version'}) {
print <<EOT;
<form method="POST" action="$cgiurl">
<input type="hidden" name="cmd" value="upgrade">
<input type="hidden" name="sid" value="$sid">
<input type="hidden" name="user" value="$user">
============ <input type="submit" value="Install Upgrade"> ============
</form>
EOT
    }
    if ($VARS{'version'} >= 3) {
print <<EOT;
<form method="POST" action="$cgiurl">
<input type="hidden" name="cmd" value="syssetup">
<input type="hidden" name="sid" value="$sid">
<input type="hidden" name="user" value="$user">
<input type="submit" value="System Setup">
</form>
EOT
  }
  }
  if ($USRMODE{$user} eq 'A' || $USRMODE{$user} eq 'S') {
print <<EOT;
<p>
<form method="POST" action="$cgiurl">
<input type="hidden" name="cmd" value="usrmgm">
<input type="hidden" name="sid" value="$sid">
<input type="hidden" name="user" value="$user">
<input type="submit" value="User Management">
</form>
EOT
  } else {
print <<EOT;
<p>
<form method="POST" action="$cgiurl">
<input type="hidden" name="cmd" value="usredit">
<input type="hidden" name="sid" value="$sid">
<input type="hidden" name="user" value="$user">
<input type="hidden" name="usrid" value="$user">
<input type="submit" name="cmdedit" value="Edit user info">
</form>
EOT
  }
  &formaccmgr;
  &formlogout;
  print "</center>";
  &footer;
}
#============================================================================ formshotdown

sub formshotdown {
    header();
    print "<center><b>Database shot down for maintenance, please try login later</b><br><br>";
    formlogin();
    print "</center>";
    footer();
}
#============================================================================ admlogin

sub admlogin {
  if ($VARS{'singleuser'} eq 'on' && $USRMODE{$user} ne 'A') { formshotdown();  return; }
  my $p = $INPUT{'passwd'};
  my $p1 = $USRPWD{$user};
  if (!$p1 || ($p ne $p1)) {
    &header;
    print "<br><center><b>Wrong password, please go back and reenter</b></center><br>";
    &footer;
    return;
  }
  $sid = int rand(1000000);
  $USRSID{$user} = $sid;
  &savepwd;
  if ($user eq $p) { &formpwd; }
  else { &mainform; }
}
#============================================================================ header

sub header {
$VARS{'bodycolor'} = '#ffffff' if $VARS{'bodycolor'} eq undef;
print<<EOF;
<HTML>
<HEAD><TITLE>RegisterMe! Admin Panel</TITLE>
EOF
print "<link rel=stylesheet href=$VARS{'imgdirurl'}/styles.css type=text/css>"
  if !$_[0];
print<<EOF;
</HEAD>\n
<body bgcolor="$VARS{'bodycolor'}">
EOF
  if ($VARS{'singleuser'} eq 'on') {
    print "<br><center><font color=\"red\"><b>**** SINGLE USER MODE ****</b></font></center><br><br>\n";
  }
}
#============================================================================ footer

sub footer {
my @lines;
if ($debug) {
  my $key;
  print "<p>";
  foreach $key (keys (%INPUT)) {
    print "$key: $INPUT{$key}<br>\n";
  }
  print "<p>Names:</br>\n";
  foreach $key (keys (%USRPWD)) {
    print "$key: $USRNAME{$key}<br>\n";
  }
}
print "<br><table width=\"100%\" border=0><tr><td><hr></td></tr><tr><td>";
print "<p><p><small>RegisterMe! (c) - 2000 - 2002, <a href=\"http://www.eastwright.com/internet/\">Eastwright Corp.</a><br>";
print "Support: <A HREF=\"mailto:$adminemail\">$adminemail</A><br>";
print "Version: $version $package";
print "</small></td></tr></table></BODY></HTML>\n";
}
#============================================================================ admloginform

sub admloginform {
  &header;
  print "<center>";
  &formlogin;
  print "</center>";
  &footer;
}
#============================================================================ errexit

sub errexit {
print <<EOT;
<html><head></head><body>
<center><br><font size=+1 color=red><b>
Fatal Error: $_[0]. Execution aborted...
</b></font></center>
</body></html>
EOT
exit;
}
#============================================================================ savepwd

sub savepwd {
  my $key;
  if (!open(PWD, ">$pwdfile")) { &errexit("Failed to open passwords file for update"); }
  flock(PWD, $LOCK_EX) if $LOCK_EX;
  foreach $key (keys (%USRPWD)) {
      print PWD "$key:$USRPWD{$key}:$USRMODE{$key}:$USRSID{$key}:$USRMAIL{$key}:$USRPHONE{$key}:$USRNAME{$key}\n";
  }
  close (PWD);
}
#============================================================================ addindex

sub addindex {
  my $f = "$_[0]/index.html";
  if (! (-e $f)) {
    if (open(IDX, ">$f")) {
      print IDX "<html><head><title>RegisterMe!</title></head><body alink=\"#0000ff\" vlink=\"#0000ff\" bgcolor=\"#fcfceb\"><center>\n";
      print IDX "<br><a href=\"$cgiurl\"><b>Admin Panel</b></a><br>\n";
      print IDX "<br><a href=\"$accmgrpl\"><b>User Manager</b></a><br>\n";
      print IDX "<br><a href=\"$VARS{'accview'}\"><b>Customer Entry</b></a><br>\n";
      print IDX "</body></html>\n";
      close(IDX);
    }
  }
}
#============================================================================ findcgidir

sub findcgidir {
  $scriptfilename = $ENV{'SCRIPT_FILENAME'};
  $scriptfilename = $ENV{'PATH_TRANSLATED'} if $ENV{'PATH_TRANSLATED'} ne undef;
  if ($scriptfilename eq undef) {
    if ($ENV{'PWD'} ne undef) {
      my @parts = split(/\//, $ENV{'SCRIPT_NAME'});
      my $f = pop @parts;
      $scriptfilename = "$ENV{'PWD'}/$f";
    }
  }
  my @cgipath = split(/\//, $scriptfilename);
  pop(@cgipath);
  $cgidir = join("\/", @cgipath);
}
#============================================================================ init

sub init {
  my $log;
  my $ok=1;
  $log = "Setting base directory $basedir...<br>";
  umask(0000);
  if (-e $basedir) {
    if (! -d $basedir) {
      $log = $log . "<font color=red>Error:</font> your system already has a file $basedir, please delete it or change <b>basedir</b> variable<br>";
      $ok = 0;
    } else {
      if ((! -w $basedir) || (! -r $basedir)) {
      $log = $log . "<font color=red>Error:</font> existing directory $basedir not available for read/write, please change access rights or change <b>basedir</b> variable<br>";
      $ok = 0;
      }
    }
  } else {
    if (!mkdir($basedir, 0777)) {
      $log = $log . "<font color=red>Error:</font> failed to create read/write directory $basedir, please change access rights of parent directory or change <b>basedir</b> variable<br>";
      $ok = 0;
    } else {
      $log = $log . "Created read/write directory $basedir<br>";
    }
  }
  if ($ok) {
    if (-e $siddir) {
      if (! -d $siddir) {
        $log = $log . "<font color=red>Error:</font> your system already has a file $siddir, please delete it or change <b>basedir</b> variable<br>";
        $ok = 0;
      } else {
        if ((! -w $siddir) || (! -r $siddir)) {
          $log = $log . "<font color=red>Error:</font> existing directory $siddir not available for read/write, please change access rights or change <b>basedir</b> variable<br>";
          $ok = 0;
        }
      }
    } else {
      if (!mkdir($siddir, 0777)) {
        $log = $log . "<font color=red>Error:</font> failed to create read/write directory $siddir, please change access rights of parent directory or change <b>basedir</b> variable<br>";
        $ok = 0;
      } else {
        $log = $log . "Created read/write directory $siddir<br>";
      }
    }
  }
  if ($ok) {
    my $tmpldir = "$basedir/tmpl";
    if (-e $tmpldir) {
      if (! -d $tmpldir) {
        $log = $log . "<font color=red>Error:</font> your system already has a file $tmpldir, please delete it or change <b>basedir</b> variable<br>";
        $ok = 0;
      } else {
        if ((! -w $siddir) || (! -r $siddir)) {
          $log = $log . "<font color=red>Error:</font> existing directory $tmpldir not available for read/write, please change access rights or change <b>basedir</b> variable<br>";
          $ok = 0;
        }
      }
    } else {
      if (!mkdir($tmpldir, 0777)) {
        $log = $log . "<font color=red>Error:</font> failed to create read/write directory $tmpldir, please change access rights of parent directory or change <b>basedir</b> variable<br>";
        $ok = 0;
      } else {
        $log = $log . "Created read/write directory $tmpldir<br>";
      }
    }
  }
  if ($ok) {
    if (-e $mbrdir) {
      if (! -d $siddir) {
        $log = $log . "<font color=red>Error:</font> your system already has a file $mbrdir, please delete it or change <b>mbrdir</b> variable<br>";
        $ok = 0;
      } else {
        if ((! -w $mbrdir) || (! -r $mbrdir)) {
          $log = $log . "<font color=red>Error:</font> existing directory $mbrdir not available for read/write, please change access rights or change <b>mbrdir</b> variable<br>";
          $ok = 0;
        }
      }
    } else {
      if (!mkdir($mbrdir, 0777)) {
        $log = $log . "<font color=red>Error:</font> failed to create read/write directory $mbrdir, please change access rights of parent directory or change <b>mbrdir</b> variable<br>";
        $ok = 0;
      } else {
        $log = $log . "Created read/write directory $mbrdir<br>";
      }
    }
  }
  if ($ok) {
    if (!open(HTA, ">$mbrdir/$htaccess")) {
      $log = $log . "<font color=red>Error:</font> failed to create file $mbrdir/$htaccess</font><br>";
      $ok=0;
    } else {
      my $str = $payname;
      $str =~  tr/ /_/;
      my $errdoc = "$VARS{'accview'}?cmd=register";
      $VARS{'errdoc'} = $INPUT{'errdoc'} if $INPUT{'errdoc'} ne undef;
      $errdoc = $VARS{'errdoc'} if $VARS{'errdoc'} ne undef;
      my $on401 = "\nErrorDocument 401 $errdoc" if $errdoc ne '*';
      my $pam = "AuthPAM_Enabled off";
      $pam = "<ifModule AuthPAM>\n$pam\n</ifModule>" if $VARS{'disablepam'} eq undef;
print HTA <<EOT;
AuthUserFile $htpasswddir/$htpasswd
AuthGroupFile /dev/null
AuthName $str
AuthType Basic$on401
Require valid-user
$pam
EOT
      close(HTA);
    }
  }
  if (-e $pwdfile) {
    if (! -f $pwdfile) {
      $log = $log . "<font color=red>Error:</font> your system already has a directory entry $pwdfile, please delete it or change <b>pwdfile</b> variable<br>";
      $ok = 0;
    } else {
      if ((! -w $pwdfile) || (! -r $pwdfile)) {
        $log = $log . "<font color=red>Error:</font> existing file $pwdfile not available for read/write, please change access rights or change <b>pwdfile</b> variable<br>";
        $ok = 0;
      }
    }
  } else {
    if (!open(PWD, ">$pwdfile")) {
      $log = $log . "<font color=red>Error:</font> failed to create read/write file $pwdfile, please change access rights of parent directory or change <b>pwdfile</b> variable<br>";
      $ok = 0;
    } else {
      close (PWD);
      $USRPWD{$user} = $INPUT{'passwd'};
      $USRMODE{$user} = 'A';
      &savepwd;
    }
  }
  if ($ok) {
    &loadcfg;   #needed to init accutil.pm
    if (!accutil::createdb()) {
      $ok=0;
      my $e = &accutil::error;
      $log = $log . "<font color=red>Error:</font> $e, please change access rights of $basedir<br>";
    }
  }
  addindex($cgidir);
  addindex($basedir);
  addindex($siddir);
  if (!$_[0]) {
print <<EOT;
<html><head></head><body>
<center><br><font size=+1 color=red><b>
Saving configuration.
</b></font></center><br><br>
$log<br>
<hr>
<a href="$cgiurl">Staff logon</a>
EOT
&footer;
  }
  return $log;
}
#============================================================================ setscripts

sub setscripts {
  my @cgi = split(/\//, $cgiurl);
  my $f = pop(@cgi);
  my ($name, $ext) = split(/\./, $f);
  $accmgrpl = join("\/", @cgi) . "/accmgr.$ext";
  $VARS{'accview'} = join("\/", @cgi) . "/accview.$ext";
}
#============================================================================ updatecgf

sub updatecfg {
  $hostaddr = $VARS{'hostaddr'};
  if ($hostaddr !~ /^htt(p|ps):\/\//i) { $hostaddr = "http://$hostaddr"; }
  if (!open (CFG, ">$cfgfile")) { &errexit("Failed to create/rewrite $cfgfile"); }
  flock(CFG, $LOCK_EX) if $LOCK_EX;
print CFG <<EOT;
hostaddr=$hostaddr
basedir=$basedir
siddir=$siddir
accmgr=$accmgrpl
accview=$VARS{'accview'}
admin=$adminpl
adminemail=$adminemail
mailer=$mailer
pwdfile=$pwdfile
uselock=$uselock
singleuser=$VARS{'singleuser'}
payname=$payname
payemail=$payemail
cmpladdr=$cmpladdr
rqaddr=$VARS{'rqaddr'}
reqemail=$reqemail
manual=$VARS{'manual'}
mbrdir=$mbrdir
mbrurl=$mbrurl
imgdirurl=$VARS{'imgdirurl'}
htpasswddir=$htpasswddir
errdoc=$VARS{'errdoc'}
emailid=$VARS{'emailid'}
notifynew=$VARS{'notifynew'}
nonewlink=$VARS{'nonewlink'}
maxip=$VARS{'maxip'}
demo=$VARS{'demo'}
bodycolor=$VARS{'bodycolor'}
cmdcolor=$VARS{'cmdcolor'}
stlcolor=$VARS{'stlcolor'}
disablepam=$VARS{'disablepam'}
version=$version
EOT
for (my $i=0; $i < 10; $i++) {
  my $name = "custom$i";
  my $view = "custom$i" . "view";
  my $edit = "custom$i" . "edit";
  my $type = "custom$i" . "type";
  my $list = "custom$i" . "list";
  my $rq = "custom$i" . "rq";
  print CFG "$name=$VARS{$name}\n$view=$VARS{$view}\n$edit=$VARS{$edit}\n$type=$VARS{$type}\n$list=$VARS{$list}\n$rq=$VARS{$rq}\n";
}
  close (CFG);
  chmod(0755, $cfgfile);
}
#============================================================================ savecgf

sub savecfg {
  if (&loadcfg) {
#not initial setup - check adminpasswd
    if ($USRMODE{$user} ne 'A' || $USRPWD{$user} ne $INPUT{'passwd'}) {
print <<EOT;
<html><head></head><body>
<center><br><br><font size=+1 color=red><b>
Wrong Admin Password! Configuration not saved.
</b></font><br><br>
Click your browser BACK key to retry.
</center>
</body></html>
EOT
    return;
    }
  } else {
#initial setup - check if admin passwords do match
    if ($INPUT{'passwd'} ne $INPUT{'passwd1'}) {
print <<EOT;
<html><head></head><body>
<center><br><br><font size=+1 color=red><b>
Passwords do not match! Configuration not saved.
</b></font><br><br>
Click your browser BACK key to retry.
</center>
</body></html>
EOT
    return;
    }
  }
  $VARS{'disablepam'} = $INPUT{'disablepam'};
  $VARS{'errdoc'} = undef if $INPUT{'errdoc'} eq undef;
  setscripts();
  $hostaddr = $INPUT{'hostaddr'};
  if ($hostaddr !~ /^htt(p|ps):\/\//i) { $hostaddr = "http://$hostaddr"; }
  $basedir = $INPUT{'basedir'};
  $basedir =~ s/\/$//;
  $INPUT{'imgdirurl'} =~ s/\/$//;
  $adminemail = $INPUT{'adminemail'};
  $mailer = $INPUT{'mailer'};
  $pwdfile = $INPUT{'pwdfile'};
  $payname = $INPUT{'payname'};
  $payname = "Members Area" if $payname eq undef;
  $payemail = $INPUT{'payemail'};
  $mbrdir = $INPUT{'mbrdir'};
  $mbrdir =~ s/\/$//;
  $mbrurl = $INPUT{'mbrurl'};
  $htpasswddir = $INPUT{'htpasswddir'};
  $htpasswddir =~ s/\/$//;
  $uselock = $INPUT{'uselock'};
  $cmpladdr = $INPUT{'cmpladdr'};
  $reqemail = $INPUT{'reqemail'};
  $siddir = $basedir . '/' . $sidsubdir;
  if (!open (CFG, ">$cfgfile")) { &errexit("Failed to create/rewrite $cfgfile"); }
  flock(CFG, $LOCK_EX) if $LOCK_EX;
print CFG <<EOT;
hostaddr=$hostaddr
basedir=$basedir
siddir=$siddir
accmgr=$accmgrpl
accview=$VARS{'accview'}
admin=$adminpl
adminemail=$adminemail
mailer=$mailer
pwdfile=$pwdfile
uselock=$uselock
singleuser=$VARS{'singleuser'}
payname=$payname
payemail=$payemail
cmpladdr=$cmpladdr
rqaddr=$INPUT{'rqaddr'}
reqemail=$reqemail
manual=$INPUT{'manual'}
mbrdir=$mbrdir
mbrurl=$mbrurl
imgdirurl=$INPUT{'imgdirurl'}
htpasswddir=$htpasswddir
errdoc=$INPUT{'errdoc'}
emailid=$INPUT{'emailid'}
notifynew=$INPUT{'notifynew'}
nonewlink=$INPUT{'nonewlink'}
maxip=$INPUT{'maxip'}
demo=$VARS{'demo'}
bodycolor=$INPUT{'bodycolor'}
cmdcolor=$INPUT{'cmdcolor'}
stlcolor=$INPUT{'stlcolor'}
disablepam=$INPUT{'disablepam'}
version=$version
EOT
for (my $i=0; $i < 10; $i++) {
  my $name = "custom$i";
  my $view = "custom$i" . "view";
  my $edit = "custom$i" . "edit";
  my $type = "custom$i" . "type";
  my $list = "custom$i" . "list";
  my $rq = "custom$i" . "rq";
  print CFG "$name=$INPUT{$name}\n$view=$INPUT{$view}\n$edit=$INPUT{$edit}\n$type=$INPUT{$type}\n$list=$INPUT{$list}\n$rq=$INPUT{$rq}\n";
}
  close (CFG);
  chmod(0755, $cfgfile);
  init();
}
#============================================================================ loadpwd

sub loadpwd {
  my @buff;
  my $line;
  if (!open(PWD, $pwdfile)) { return 0; }
  flock(PWD, $LOCK_EX) if $LOCK_EX;
  @buff = <PWD>;
  close (PWD);
  chomp(@buff);
  foreach $line (@buff) {
    my $name; my $passwd; my $rights; my $s; my $m; my $p; my $n;
    ($name, $passwd, $rights, $s, $m, $p, $n) = split(/:/, $line);
    if ($name) {
      $USRPWD{$name} = $passwd;
      $USRMODE{$name} = $rights;
      $USRSID{$name} = $s;
      $USRMAIL{$name} = $m;
      $USRPHONE{$name} = $p;
      $USRNAME{$name} = $n;
    }
  }
  return 1;
}
#============================================================================ loadcgf

sub loadcfg {
  my @buff;
  my $line;
  if (! open(CFG, $cfgfile)) { return 0; }
  @buff = <CFG>;
  close(CFG);
  chomp(@buff);
  foreach $line (@buff) {
    my $name;
    my $value;
    ($name, $value) = split(/=/, $line);
    if ($value) { $VARS{$name} = $value; }
  }
  $hostaddr = $VARS{'hostaddr'};
  $basedir = $VARS{'basedir'};
  $siddir = $VARS{'siddir'};
  $accmgrpl = $VARS{'accmgr'};
  $adminemail = $VARS{'adminemail'};
  $mailer = $VARS{'mailer'};
  $pwdfile = $VARS{'pwdfile'};
  $uselock = $VARS{'uselock'};
  $payname = $VARS{'payname'};
  $payemail = $VARS{'payemail'};
  $cmpladdr = $VARS{'cmpladdr'};
  $reqemail = $VARS{'reqemail'};
  $mbrdir = $VARS{'mbrdir'};
  $mbrurl = $VARS{'mbrurl'};
  $htpasswddir = $VARS{'htpasswddir'};
  if ($VARS{'customview'} ne undef) {
    $VARS{'custom1view'} = 'on';
    $VARS{'custom2view'} = 'on';
  }
  if ($VARS{'customedit'} ne undef) {
    $VARS{'custom1edit'} = 'on';
    $VARS{'custom2edit'} = 'on';
  }
  $VARS{'custom1'} = 'Custom 1' if $VARS{'custom1'} eq undef;
  $VARS{'custom2'} = 'Custom 2' if $VARS{'custom2'} eq undef;
  $VARS{'bodycolor'} = '#fcfceb' if $VARS{'bodycolor'} eq undef;
  $VARS{'cmdcolor'} = '#b5cc94' if $VARS{'cmdcolor'} eq undef;
  $VARS{'stlcolor'} = '#fff0cf' if $VARS{'stlcolor'} eq undef;
  accutil::init(%VARS);
  if ($uselock) { $LOCK_EX = "2"; }
  if (!loadpwd()) { return 0; }
  return 1;
}
#======================================================================= checkrw

sub checkrw {
  my $warning = "<font color=red><b>WARNING:</font> ";
  if (-e $cfgfile && ! (-d $cfgfile)) {
    if (! -w $cfgfile) {
      return "$warning The $cfgfile is not writeable, please change access mode before submitting this form<b><br><br>";
    }
    if (! -r $cfgfile) {
      return "$warning The $cfgfile exists but is not readable, please change access mode and reload this form<b><br><br>";
    }
  } else {
    if (-e accutil::configoverride()) {
      my $dir = $cfgfile;
      if ($cfgfile !~ /\/$/) {
        my @parts = split (/\//, $cfgfile);
        pop(@parts);
        $dir = join("\/", @parts);
        $dir = "/" if $dir eq undef;
      }
      if (! -e $dir) {
         return "$warning The directory </b><tt>$dir</tt><b> specified in your configoverride.cgi does not exist,<br>".
                "please create the directory and make sure it is writeable before submitting this form<b>.<br><br>";
      }
      if (! -w $dir) {
         return "$warning The directory </b><tt>$dir</tt><b> specified in your configoverride.cgi ".
                "is not writeable,<br> please change access mode ".
                "before submitting this form<b><br><br>";
      }
    } else {
      if (! -w $cgidir) {
         return "$warning The directory </b><tt>$cgidir/</tt><b> is not writeable,<br> please change access mode or create ".
                "<a href=\"\" target=_blank>configoverride.cgi</a> file before submitting this form<b><br><br>";
      }
    }
  }
  return undef;
}
#============================================================================ setup

sub setup {
  my $f = int rand(10000000);
  my $basesubdir = "data$f";
  my @checked;
  if (!$USRPWD{$user}) { $uselock = "on"; $cmpladdr=0; $reqemail=0; }
  if ($uselock) { $checked[0]="checked"; }
  if ($cmpladdr) { $checked[1]="checked"; }
  if ($reqemail) { $checked[2]="checked"; }
  if ($VARS{'rqaddr'} ne undef) {$checked[3]="checked";}
  if ($VARS{'manual'} ne undef) {$checked[4]="checked";}
  if ($VARS{'notifynew'} ne undef) {$checked[5]="checked";}
  if ($VARS{'nonewlink'} ne undef) {$checked[6]="checked";}
  if ($VARS{'disablepam'} ne undef) {$checked[7]="checked";}
  $VARS{'bodycolor'} = '#fcfceb' if $VARS{'bodycolor'} eq undef;
  $VARS{'cmdcolor'} = '#b5cc94' if $VARS{'cmdcolor'} eq undef;
  $VARS{'stlcolor'} = '#fff0cf' if $VARS{'stlcolor'} eq undef;
  my $cleansetup;
  if ($basedir eq undef) {
    $basedir = "$cgidir/$basesubdir";
    $cleansetup=1;
  }
  if ($VARS{'imgdirurl'} eq undef) {
    my @imgurlpath = split(/\//, $ENV{'SCRIPT_NAME'});
    pop(@imgurlpath);
    $VARS{'imgdirurl'} = join("\/", @imgurlpath);
  }
if ($htpasswddir eq undef) {
  $htpasswddir = $basedir;
}
if ($adminemail eq undef) { $adminemail = $ENV{'SERVER_ADMIN'}; }
if (!$pwdfile) {
  $f = int rand(1000000);
  $pwdfile = "$basedir/pwd$f.pwd";
}
if ($hostaddr eq undef) { $hostaddr = $ENV{'HTTP_HOST'}; }
 my $warn777 = checkrw();
header(1);
print <<EOT;
<SCRIPT Language="JavaScript">
function regmehelp(topic) {
win=window.open('http://www.eastwright.com/internet/register/setuphelp.html#'+topic,
                'registermehelp',
                'top=0,left=0,height=300,width=500,scrollbars=yes');
win.focus();
}
</SCRIPT>
<center><br><font size=+1 color=red><b>
RegisterMe! $package System Setup
</b></font><br><br>
<b>Release $version
<a href="http://www.eastwright.com/internet/register/log.html"><img src="http://www.eastwright.com/internet/register/liteautoupdate.pl?$version" border="0" width="95" height="10"></a>
<br><br></b>$warn777
<table border="1" cellspacing="0" cellpadding="4">
<form method="POST" action="$cgiurl?cmd=savecfg">
<tr><td colspan=2><center><b><a name="ss"></a>System Settings</b></center></td></tr>
<tr><td align=right><b><a href=#ss onclick="regmehelp('hostaddress')">Host Address</a></b></td><td><input type="text" size="50" name="hostaddr" value="$hostaddr"></td></tr>
<tr><td align=right><b><a href=#ss onclick="regmehelp('basedir')">Base Directory</a></b></td><td><input type="text" size="80" name="basedir" value="$basedir"></td></tr>
<tr><td align=right><b><a href=#ss onclick="regmehelp('adminpwd')">Admin Passwords File</a></b></td><td><input type="text" size="80" name="pwdfile" value="$pwdfile"></td></tr>
<tr><td align=right><b><a href=#ss onclick="regmehelp('imgdir')">Image Directory URL</a></b></td><td><input type="text" size="80" name="imgdirurl" value="$VARS{'imgdirurl'}"></td></tr>
<tr><td align=right><b><a href=#ss onclick="regmehelp('sendmail')">Sendmail Path</b></td><td><input type="text" size="50" name="mailer" value="$mailer"></td></tr>
<tr><td align=right><b><a href=#ss onclick="regmehelp('uselock')">Use File Locking</a></b></td><td><input type="checkbox" name="uselock" $checked[0]></td></tr>
<tr><td align=right><b><a href=#ss onclick="regmehelp('disablepam')">Force Disable AuthPAM</a></b></td><td><input type="checkbox" name="disablepam" $checked[7]></td></tr>
<tr><td align=right><b><a href=#ss onclick="regmehelp('adminemail')">Admin Email Address</a></b></td><td><input type="text" size="30" name="adminemail" value="$adminemail"></td></tr>
<tr><td align=right><b>Background Color</b></td><td><input type="text" size="10" name=bodycolor value="$VARS{'bodycolor'}"></td></tr>
<tr><td align=right><b>Status Line Color</b></td><td><input type="text" size="10" name=stlcolor value="$VARS{'stlcolor'}"></td></tr>
<tr><td align=right><b>Menu Color</b></td><td><input type="text" size="10" name=cmdcolor value="$VARS{'cmdcolor'}"></td></tr>
<tr><td colspan=2><center><b><br><a name="ppds"></a>Password Protected Directory Settings</b></center></td></tr>
<tr><td align=right><b><a href=#ppds onclick="regmehelp('servpath')">Server Path</a></b></td><td><input type="text" size="80" name="mbrdir" value="$mbrdir"></td></tr>
<tr><td align=right><b><a href=#ppds onclick="regmehelp('url')">URL</a></b></td><td><input type="text" size="80" name="mbrurl" value="$mbrurl"></td></tr>
<tr><td align=right><b><a href=#ppds onclick="regmehelp('autherror')">Authorization Failure URL</a></b></td><td><input type="text" size="80" name="errdoc" value="$VARS{'errdoc'}"></td></tr>
<tr><td align=right><b><a href=#ppds onclick="regmehelp('pwddir')">Passwords Directory</a></b></td><td><input type="text" size="80" name="htpasswddir" value="$htpasswddir"></td></tr>
<tr><td align=right><b><a href=#ppds onclick="regmehelp('maxip')">Max IP addresses allowed</a></b></td><td><input type="text" size="3" name="maxip" value="$VARS{'maxip'}"></td></tr>
<tr><td colspan=2><center><b><br><a name="cas">Customer Account Settings</a></b></center></td></tr>
EOT
if ($cleansetup) {
print <<EOT;
<tr><td align=right><b><a href="#cas" onclick="regmehelp('emailid')">Use Email as ID</a>
<font color=red size="-1"><br><u>May Not</u> Be Changed Later!</font></b>
</td><td><input type="checkbox" name="emailid"></td></tr>
EOT
} else {
  my $emailidstatus = 'Enabled';
  $emailidstatus = 'Disabled' if $VARS{'emailid'} eq undef;
print <<EOT;
<tr><td align=right><b><a href="#cas" onclick="regmehelp('emailid')">Use Email as ID</a></b>
</td><td>$emailidstatus<input type="hidden" name="emailid" value=$VARS{'emailid'}></td></tr>
EOT
}
print <<EOT;
<tr><td align=right><b><a href="#cas" onclick="regmehelp('compladdr')">Complete Address</a></b></td><td><input type="checkbox" name="cmpladdr" $checked[1]></td></tr>
<tr><td align=right><b><a href="#cas" onclick="regmehelp('rqaddr')">Address Required</a></b></td><td><input type="checkbox" name="rqaddr" $checked[3]></td></tr>
<tr><td align=right><b><a href="#cas" onclick="regmehelp('validemail')">Verify Email</a></b></td><td><input type="checkbox" name="reqemail" $checked[2]></td></tr>
<tr><td align=right><b><a href="#cas" onclick="regmehelp('manual')">Manual Approval</a></b></td><td><input type="checkbox" name="manual" $checked[4]></td></tr>
<tr><td align=right><b><a href="#cas" onclick="regmehelp('notifynew')">New Account Notices</a></b></td><td><input type="checkbox" name="notifynew" $checked[5]></td></tr>
<tr><td align=right><b><a href="#cas" onclick="regmehelp('nonewlink')">Hide "Register Now!" Link</a></b></td><td><input type="checkbox" name="nonewlink" $checked[6]></td></tr>
<tr><td colspan="2"><center><b><br><a name="cf"></a><a href="#cf" onclick="regmehelp('customfields')">Custom Fields</a></b></td></tr>
<tr><td colspan="2">
<table>
<tr><td colspan=2></td><td colspan=2><center><b><u>Customer access</u></b></center></td>
<td colspan=3>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<u><b>Appearance</u></b></td></tr>
<tr><td><b>ID</b></td>
<td><b>&nbsp;Name</b></td>
<td><b><center>view</center></b></td>
<td><b><center>edit</center></b></td>
<td><b><center>type</center></b></td>
<td><b><center>values</center></b></td>
<td><b><center>rq</center></b></td></tr>
EOT
for (my $i=0; $i < 10; $i++) {
  my $name = "custom$i";
  my $rq = "custom$i" . "rq";
  my $view = "custom$i" . "view";
  my $edit = "custom$i" . "edit";
  my $type = "custom$i" . "type";
  my $list = "custom$i" . "list";
  my $checkview = 'checked' if $VARS{$view} ne undef;
  my $checkedit = 'checked' if $VARS{$edit} ne undef;
  my $checkrq = 'checked' if $VARS{$rq} ne undef;
print <<EOT;
<tr><td>$name</td><td>&nbsp;<input type="text" size="20" name="$name" value="$VARS{$name}"></td>
<td><center><input type="checkbox" name="$view" $checkview></center></td>
<td><center><input type="checkbox" name="$edit" $checkedit></center></td>
<td><select name=$type>
EOT
  my @types = ('text', 'checkbox', 'select');
  foreach my $t (@types) {
    print "<option";
    print " selected" if $VARS{$type} eq $t;
    print ">$t\n";
  }
print <<EOT;
</select></td>
<td><input type=text size=35 name=$list value="$VARS{$list}"></td>
<td><center><input type=checkbox name=$rq $checkrq></center></td>
</tr>
EOT
}

print <<EOT;
</table>
</td></tr>
<tr><td colspan="2"><center><b><br><a name="ci"></a>Company Info</b></td></tr>
<tr><td align=right><b><a href="#ci" onclick="regmehelp('companyname')">Company Name</a></b></td><td><input type="text" size="50" name="payname" value="$payname"></td></tr>
<tr><td align=right><b><a href="#ci" onclick="regmehelp('companyemail')">Company Email</a></b></td><td><input type="text" size="30" name="payemail" value="$payemail"></td></tr>
<tr><td colspan="2"><center><b><br><a name="aa"></a><a href="#aa" onclick="regmehelp('aa')">Admin Account</a></b></td></tr>
<tr><td align=right><b>Login:</b></td><td><input type="text" size="10" name="user" value="$user"></td><tr>
<tr><td align=right><b>Password:</b></td><td><input type="password" size="10" name="passwd"></td><tr>
EOT
if ($USRPWD{$user} eq undef) {
  print "<tr><td align=right><b>Repeat password:</b></td><td><input type=\"password\" size=\"10\" name=\"passwd1\"></td></tr>\n";
}
print <<EOT;
<tr><td>&nbsp;</td><td><input type="submit" value="Save Configuration"></td></tr>
</form></table></center><hr>
EOT
my $key;
print "<br><center><b>Environment Variables</b><br>(for your reference)</center><br><br>\n";
foreach $key (sort keys (%ENV)) {
  print "$key: $ENV{$key}<br>\n";
}
print <<EOT;
</body></html>
EOT
}
#============================================================================ upgrade

sub upgrade {
  setscripts();
  updatecfg();
  my $log;
  if ($VARS{'version'} < 3) { $log = upgradedb(); }
  if ($log ne undef) {
    mainform("Fatal Error: $log<br><br>");
    return;
  }
  $log=init(1);
  if ($log eq undef) {
    mainform("System upgraded to version $version");
  } else {
    mainform($log . "<br>System upgraded to version $version");
  }
}
#============================================================================ upgradedb

sub upgradedb {
  return "Failed to open accounts database for upgrade" if !open(ACC, "+<".accutil::getaccdbname());
  flock(ACC, $LOCK_EX) if $LOCK_EX;
  my @buffin = <ACC>;
  chomp @buffin;
  my $header=1;
  my @buffout;
  foreach my $line (@buffin) {
    next if $header && $line !~ /FAKEPRINT/;
    if ($header && $line =~ /FAKEPRINT/) {
      $header = 0;
      next;
    }
    last if !$header && $line =~ /FAKEPRINT/;
    my %r = accutil::line2rec($line);
    $r{'approved'} = "--auto--";
    $r{'approved'} = undef if $r{'openbalance'} > 0;
    $r{'verified'} = 1;
    $r{'verified'} = 0 if $r{'openbalance'} > 0;
    @buffout = (@buffout, accutil::rec2line(%r));
  }
  seek(ACC, 0, 0);
  truncate(ACC, 0);
  foreach my $line (@buffout) {
    print ACC "$line\n";
  }
  close ACC;
  return undef;
}