#!/usr/bin/perl
use strict;
require 5.003;
use accutil;
print "Content-type: text/html\n\n";

my $version = '3.04';
my $package = "Lite";

my $cfgfile = accutil::cfgfile();
my $accautoprefix = "CUS1";
my $plsseltag = "--- Please Select ---";
my $basedir;
my $singleuser;
my $adminemail;
my $mailer;
my $debug = 0;
my $LOCK_EX;
my ($payname, $payemail);
my $cmpladdr;
my $reqemail;
my ($mbrdir, $mbrurl);
my $hostaddr;
my $cgidir;
my %VARS;


my $starttime = time();
my $headeron = 0;
my $accid;
my $siddir;
my ($cmd, @pairs, $pair);
my %INPUT;
my $cgiurl = $ENV{'SCRIPT_NAME'};
my $sid;
my $buffer;
my (@statusline, @cmdline, @bodylines);

@pairs = split(/&/, $ENV{'QUERY_STRING'});
foreach $pair (@pairs) {
        my ($name, $value);
        ($name, $value) = split(/=/, $pair);
        $value =~ s/%0D%0A/ /g;
        $value =~ s/%0A%0D/ /g;
        $value =~ tr/+/ /;
        $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
        if ($INPUT{$name}) { $INPUT{$name} = $INPUT{$name}.",".$value; }
        else { $INPUT{$name} = $value; }
}

read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
        my ($name, $value);
        ($name, $value) = split(/=/, $pair);
        $value =~ s/%0D%0A/ /g;
        $value =~ s/%0A%0D/ /g;
        $value =~ tr/+/ /;
        $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
        if ($INPUT{$name}) { $INPUT{$name} = $INPUT{$name}.",".$value; }
        else { $INPUT{$name} = $value; }
}
$cmd = $INPUT{'cmd'};
$accid = $INPUT{'accid'};

findcgidir();
if (!loadcfg()) { errexit("Failed to read config file"); }
if ($singleuser eq 'on') {
  loginform("Database shot down for maintenance, please try login later");
  exit;
}
if ($cmd eq 'lostpasswd') { lostpasswd(); exit; }
if ($cmd eq 'register') { formaccntopen(); exit; }
if ($cmd eq 'formaccntopen') { formaccntopen(); exit; }
if ($cmd eq 'formlostpasswd') { formlostpasswd(); exit; }
if ($cmd eq 'accntopen') { accntopen(); exit; }
$sid = $INPUT{'sid'};
if ($cmd eq 'activate') { activate(); exit; }
if ($cmd eq 'login') { login(); }
if ($sid eq undef) { loginform(); exit; }
if (!checksid()) { loginform(); exit; }
if ($cmd eq 'gomain') { formmain(); exit; }
if ($cmd eq 'accedit') { accedit(); exit; }
if ($INPUT{'cmdmain.x'} ne undef) { formmain(); exit; }
if ($INPUT{'cmdlogoff.x'} ne undef) { logoff(); exit; }
if ($INPUT{'cmdview.x'} ne undef) { formviewaccnt(); exit; }
if ($INPUT{'cmdedit.x'} ne undef) { formeditaccnt(); exit; }
if ($INPUT{'cmdactivate.x'} ne undef) { formactivate(); exit; }

&header;
print "unknown command";
&footer;
exit;

#============================================================================ confirm

sub confirm {
  my (@args, $key);
  my @exclude = ('cmd', 'template', 'cuspasswd', 'cuspasswd1');
  foreach $key (keys(%INPUT)) {
    if (!grep(/^$key$/, @exclude)) {
      my $val = $INPUT{$key};
      $val =~ s/([^a-zA-Z0-9_])/sprintf("%%%X", ord($1))/eg;
      push (@args, "$key=$val");
    }
  }
  $key = join('&', @args);
  my $url = $INPUT{'confirmurl'};
  if ($url =~ /\?/) { $url .= "&$key"; }
  else { $url .= "?$key"; }
print <<EOT;
<html><head><title>Loading confirmation page...</title>
<meta http-equiv="refresh" content="0; url=$url">
</head><body><br><br><center><br><b>Loading <a href="$url">Confirmation Page</a></b></center>
</body></html>
EOT
}
#============================================================================ loadtmpl

sub loadtmpl {
  my $msg = $_[0];
  my $tmplf = $INPUT{'template'};
  errexit("missing template name") if $tmplf eq undef;
  my @parts = split(/\//, $tmplf);
  $tmplf = pop(@parts);
  $tmplf = "$VARS{'basedir'}/tmpl/$tmplf";
  errexit("template file $INPUT{'template'} does not exist") if ! -e $tmplf;
  errexit("failed to open template file $INPUT{'template'}") if !open(TMPL, $tmplf);
  flock(TMPL, $LOCK_EX) if $LOCK_EX;
  my @buff = <TMPL>;
  close(TMPL);
  my %tags;
  $tags{'ACCID'} = $INPUT{'accid'};
  $tags{'PASSWD'} = $INPUT{'cuspasswd'};
  $tags{'PASSWD1'} = $INPUT{'cuspasswd1'};
  $tags{'NAME'} = $INPUT{'name'};
  $tags{'LNAME'} = $INPUT{'lname'};
  $tags{'STREET'} = $INPUT{'street'};
  $tags{'CITY'} = $INPUT{'city'};
  $tags{'STATE'} = $INPUT{'state'};
  $tags{'ZIP'} = $INPUT{'zip'};
  $tags{'COUNTRY'} = $INPUT{'country'};
  $tags{'PHONE'} = $INPUT{'phone'};
  $tags{'BIZPHONE'} = $INPUT{'bizphone'};
  $tags{'FAX'} = $INPUT{'fax'};
  $tags{'EMAIL'} = $INPUT{'email'};
  $tags{'NOTES'} = $INPUT{'notes'};
  $tags{'ERRORMESSAGE'} = $msg;
  for (my $i=0; $i < 10; $i++) {
    my $str;
    $tags{"CUSTOMARG$i"} = $INPUT{"customarg$i"};
    $tags{"CUSTOM$i"} = $INPUT{"custom$i"};
    if ($VARS{"custom$i"."type"} eq 'select') {
      $str = "<select name=\"custom$i\">\n<option>$plsseltag\n";
      my @list = split(/;/,$VARS{"custom$i"."list"});
      foreach my $option (@list) {
        $str .= "<option";
        $str .= " selected" if $INPUT{"custom$i"} eq $option;
        $str .= ">$option\n";
      }
      $str .= "</select>\n";
    } elsif ($VARS{"custom$i"."type"} eq 'checkbox') {
      my $checked = 'checked' if $INPUT{"custom$i"} ne undef;
      $str = "<input type=checkbox name=custom$i $checked>\n";
    } else {
      $str = "<input type=text name=custom$i size=25 value=\"".$INPUT{"custom$i"}."\">\n";
    }
    $tags{"CGI_CUSTOM$i"} = $str;
  }
  foreach my $l (@buff) {
   $l =~ s/\*([A-Z0-9_]+)\*/$tags{$1}/g;
   print $l;
  }
}
#============================================================================ lostpasswd

sub lostpasswd {
  my $idtitle = 'User ID';
  $idtitle = 'Email Address' if $VARS{'emailid'} ne undef;
  if ($accid eq undef) { formlostpasswd("Missing $idtitle"); return; }
  my %r = accutil::getaccnt($accid);
  if (!%r) { formlostpasswd("Account $accid does not exist"); return; }
  if ($r{'email'} eq undef) { formlostpasswd("Account $accid does not have email address"); return; }
  if (open(MAIL, "|$mailer -t")) {
    print MAIL "To: $r{'email'}\n";
    print MAIL "From: $payemail\n";
    print MAIL "Subject: Your account password\n\n";
    my $subscriber = "subscriber";
    if ($r{'name'} ne undef) { $subscriber="$r{'name'} $r{'lname'}"; }
    print MAIL "Dear $subscriber\n\n";
    print MAIL "Your password is $r{'passwd'}. Now you can access\n\nMember Area ($hostaddr$mbrurl)\n\n";
    print MAIL "or login into Account Management Panel\n\n$hostaddr"."$cgiurl\n\n";
    print MAIL "Thanks for using our service,\n$payname\n\n";
    close(MAIL);
    loginform("Your password just emailed to your address on record.");
  } else {
    header();
    errorpage("Unable to start mailing program. Please notify <a href=\"mailto:$adminemail\">Administrator</a>");
    footer();
 }
}
#============================================================================ formlostpasswd

sub formlostpasswd {
  &header;
  my $msg = $_[0];
  if ($msg ne undef) { $msg = "<font color=red><b>$msg</b></font><br><br>"; }
  my %r;
  cmlprint("<form method=\"POST\" action=\"$cgiurl\">\n");
  cmlprint("<input type=hidden name=accid value=\"$INPUT{'accid'}\">".
           "<input type=\"image\" name=\"cmdmain\" src=\"$VARS{'imgdirurl'}/cmdcancel.gif\" border=\"0\" width=\"50\" height=\"20\" alt=\"Cancel\">");
  stlprint("<table border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\"><tr><td>");
  stlprint("<center><b>Password Finder</b></center></td></tr></table>\n\n");
  cmlprint("\n\n");
  bodyprint("</form><br><br><center>$msg\n");
  bodyprint("<table width=\"80%\">\n");
  bodyprint("<tr><td width=\"25%\"><form method=\"POST\" action=\"$cgiurl\">\n");
  bodyprint("<input type=\"hidden\" name=\"cmd\" value=\"lostpasswd\">\n");
  bodyprint("<td></td><td width=\"50%\"></td></tr>");
  my $str = "Enter your User ID:";
  $str = "Enter your email address:" if $VARS{'emailid'} ne undef;
  bodyprint("<tr><td></td><td><b>$str</b></td><td><input type=\"text\" name=\"accid\" size=\"20\"></td></tr>\n");
  bodyprint("<tr><td></td><td></td><td><input type=\"submit\" value=\"Send Password\"></td></tr></form></table>");
  bodyprint("<br>Your password will be sent to your email address.\n") if $VARS{'emailid'} eq undef;
  bodyprint("</center>\n\n");
  &footer;
}
#============================================================================ activate

sub activate {
  my $type = 'Verification';
  if ($accid eq undef) { formaccntopen("Missing account ID"); return; }
  my %r = accutil::getaccnt($accid);
  if (!%r) { formaccntopen("Account $accid does not exist"); return; }
  $type = 'Activation' if $VARS{'manual'} eq undef && !accutil::enabled(%r);
  my $acode = $INPUT{'acode'};
  if ($acode eq undef) { formactivate("Missing $type Code"); return; }
  if ($acode ne $r{'openbalance'}) { formactivate("Invalid $type Code"); return ;}
  $r{'openbalance'} = 0;
  $r{'verified'} = 1;
  if ($r{'newemail'} ne undef) {
    $r{'email'} = $r{'newemail'};
    $r{'newemail'} = undef;
  }
  if (!accutil::editaccnt(%r)) {
    header();
    my $e = accutil::error();
    errorpage("Error: $e");
    footer();
    return;
  }
  $sid = int(rand(1000000)) + 1;
  my $f = "$siddir/$accid";
  if (!open(SIDF, ">$f")) { errexit("Unable create customer session"); }
  flock(SIDF, $LOCK_EX) if $LOCK_EX;
  print SIDF "$sid\n";
  close(SIDF);
  if ($type eq 'Verification') {
    formmain("Your email address verified!");
  } else {
    formmain("Your account activated!");
  }
}
#============================================================================ formactivate

sub formactivate {
  &header;
  my $type = 'Verification';
  my $msg = $_[0];
  if ($msg ne undef) { $msg = "<font color=red><b>$msg</b></color><br><br>"; }
  my %r = accutil::getaccnt($accid);
  $type = 'Activation' if $VARS{'manual'} eq undef && !accutil::enabled(%r);
  cmlprint("<form method=\"POST\" action=\"$cgiurl\">\n");
  bodyprint("<input type=\"hidden\" name=\"accid\" value=\"$accid\">\n");
  bodyprint("<input type=\"hidden\" name=\"sid\" value=\"$sid\">\n");
  cmlprint("<input type=\"image\" name=\"cmdmain\" src=\"$VARS{'imgdirurl'}/cmdcancel.gif\" border=\"0\" width=\"50\" height=\"20\" alt=\"Cancel\">");
  stlprint("<table border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\"><tr><td>");
  stlprint("<center><b>$type Form</b></center></td></tr></table>\n\n");
  cmlprint("\n\n");
  bodyprint("</form><br><br><center>$msg\n");
  bodyprint("<table width=\"80%\">\n");
  bodyprint("<tr><td width=\"25%\"><form method=\"POST\" action=\"$cgiurl\">\n");
  bodyprint("<input type=\"hidden\" name=\"cmd\" value=\"activate\">\n");
  bodyprint("<input type=\"hidden\" name=\"accid\" value=\"$accid\">\n");
  bodyprint("<input type=\"hidden\" name=\"sid\" value=\"$sid\">\n");
  bodyprint("<td></td><td width=\"50%\"></td></tr>");
  bodyprint("<tr><td></td><td><b>$type Code:</b></td><td><input type=\"text\" name=\"acode\" size=\"10\"></td></tr>\n");
  bodyprint("<tr><td></td><td></td><td><input type=\"submit\" value=\"Activate\"></td></tr></form></table></center>\n\n");
  &footer;
}
#============================================================================ accntopen

sub accntopen {
  if ($accid eq undef) { formaccntopen("Missing account ID"); return; }
  if ($VARS{'emailid'} eq undef && $accid =~ /^$accautoprefix/) {
    $INPUT{'accid'} = undef;
    formaccntopen("Account ID may not begin with $accautoprefix.");
    return;
  }
  my %r;
  my $tm = time();
  srand($tm);
  $r{'opendate'} = $tm - ($tm % (60 * 60 * 24)) + 1;;
  if ($reqemail) { $r{'openbalance'} = int(rand(1000000)) + 1; }
  else { $r{'openbalance'} = 0; }
  $r{'id'} = $accid;
  $r{'name'} = $INPUT{'name'};
  if ($VARS{'rqaddr'} ne undef && $r{'name'} eq undef) {
      formaccntopen("Missing required field: First Name"); return;
  }
  $r{'lname'} = $INPUT{'lname'};
  if ($VARS{'rqaddr'} ne undef && $r{'lname'} eq undef) {
      formaccntopen("Missing required field: Last Name"); return;
  }
  $r{'street'} = $INPUT{'street'};
  if ($VARS{'rqaddr'} ne undef && $r{'street'} eq undef && $VARS{'cmpladdr'} ne undef) {
      formaccntopen("Missing required field: Street Address"); return;
  }
  $r{'city'} = $INPUT{'city'};
  if ($VARS{'rqaddr'} ne undef && $r{'city'} eq undef) {
      formaccntopen("Missing required field: City"); return;
  }
  $r{'state'} = $INPUT{'state'};
  if ($VARS{'rqaddr'} ne undef && $r{'state'} eq undef) {
      formaccntopen("Missing required field: State"); return;
  }
  $r{'zip'} = $INPUT{'zip'};
  if ($VARS{'rqaddr'} ne undef && $r{'zip'} eq undef) {
      formaccntopen("Missing required field: ZIP"); return;
  }
  $r{'country'} = $INPUT{'country'};
  if ($VARS{'rqaddr'} ne undef && $r{'country'} eq undef) {
      formaccntopen("Missing required field: ZIP"); return;
  }
  for (my $i=0; $i < 10; $i++) {
    next if $VARS{"custom$i"} eq undef;
    $r{"custom$i"} = $INPUT{"custom$i"};
    next if $VARS{"custom$i"."rq"} eq undef;
    if ($r{"custom$i"} eq undef || $r{"custom$i"} eq $plsseltag) {
      formaccntopen("Missing required field: ".$VARS{"custom$i"}); return;
    }
  }
  $r{'phone'} = $INPUT{'phone'};
  $r{'fax'} = $INPUT{'fax'};
  if ($VARS{'emailid'} ne undef) {
    $r{'email'} = $accid;
  } else {
    $r{'email'} = $INPUT{'email'};
  }
  if ($reqemail && ($r{'email'} eq undef || $r{'email'} !~ /\@/)) { formaccntopen("Missing or invalid email address"); return; }
  my $s = $INPUT{'cuspasswd'};
  if ($s eq undef) { formaccntopen("Missing password"); return; }
  if (length($s) < 6){
    formaccntopen("Password must be 6 or more characters");
    return;
  } elsif ($s =~ /\W/) {
    formaccntopen("Password must contain alphanumeric characters only");
    return;
  } elsif ($s ne $INPUT{'cuspasswd1'}) {
    formaccntopen("Passwords do not match");
    return;
  }
  $r{'passwd'} = $s;
  $INPUT{'passwd'} = $s;
  if (!accutil::addaccnt(%r)) { formaccntopen(accutil::error()); return; }
  $sid = int(rand(1000000));
  my $f = "$siddir/$accid";
  if (!open(SIDF, ">$f")) { errexit("Unable create customer session"); }
  flock(SIDF, $LOCK_EX) if $LOCK_EX;
  print SIDF "$sid\n";
  close(SIDF);
  if ($VARS{'notifynew'} ne undef && open(MAIL, "|$mailer -t")) {
    print MAIL "To: $VARS{'payemail'}\n";
    print MAIL "From: \"$VARS{'payname'}\" <$VARS{'payemail'}>\n";
    print MAIL "Subject: New Account Notice\n\n";
    print MAIL "New account info:\n\n";
    print MAIL "User ID: $r{'id'}\n" if $VARS{'emailid'} eq undef;
    print MAIL "Email Address: $r{'email'}\n";
    print MAIL "Name: $r{'name'} $r{'lname'}\n" if $r{'name'}.$r{'lname'} ne undef;
    print MAIL "Country: $r{'country'}\n" if $r{'country'} ne undef;
    print MAIL "\nAwaiting approval.\n" if $VARS{'manual'} ne undef;
    print MAIL "\n";
    close MAIL;
  }
  if (!$reqemail && $VARS{'manual'} eq undef) {
    if ($INPUT{'confirmurl'} eq undef) { formmain("Congratulations! You have set up an account with us."); return; }
    else { confirm(); return; }
  }
  if ($reqemail) {
    if (open(MAIL, "|$mailer -t")) {
      print MAIL "To: $r{'email'}\n";
      print MAIL "From: \"$VARS{'payname'}\" <$VARS{'payemail'}>\n";
      if ($VARS{'manual'} eq undef) {
        print MAIL "Subject: Your account activation code\n\n";
      } else {
        print MAIL "Subject: Your account verification code\n\n";
      }
      my $subscriber = "subscriber";
      if ($r{'name'} ne undef) { $subscriber="$r{'name'} $r{'lname'}"; }
      print MAIL "Dear $subscriber\n\n";
      print MAIL "Recently we received the following registration information:\n\n";
      if ($VARS{'emailid'} eq undef) {
        print MAIL "Customer ID: $r{'id'}\n";
      } else {
        print MAIL "Email Address: $r{'id'}\n";
      }
      print MAIL "Name: $r{'name'} $r{'lname'}\n" if $r{'name'}.$r{'lname'} ne undef;
      if ($cmpladdr) {
        print MAIL "$r{'street'}\n" if $r{'street'} ne undef;
      }
      print MAIL "$r{'city'}\n" if $r{'city'} ne undef;
      print MAIL "$r{'state'} $r{'zip'}\n" if $r{'state'}.$r{'zip'} ne undef;
      print MAIL "$r{'country'}\n" if $r{'country'} ne undef;
      if ($cmpladdr) {
        print MAIL "ph. $r{'phone'}\n" if $r{'phone'} ne undef;
        print MAIL "fax. $r{'fax'}\n" if $r{'fax'} ne undef;
      }
      print MAIL "email: $r{'email'}\n\n" if $VARS{'emailid'} eq undef && $r{'email'} ne undef;
      print MAIL "\n";
      if ($VARS{'manual'} eq undef) {
        print MAIL "In order to access Member Area ($hostaddr$mbrurl) and other site features please activate your account.\n\n";
        print MAIL "Your account activation code: $r{'openbalance'}\n\n";
        print MAIL "In order to activate your account you can either use the following link :\n\n";
        print MAIL "$hostaddr"."$cgiurl?accid=$r{'id'}&cmd=activate&acode=$r{'openbalance'}\n\n";
        print MAIL "or enter the activation code into activation form at ";
        print MAIL "$hostaddr"."$cgiurl (you will need to login first)\n\n";
      } else {
        print MAIL "Access to Member Area ($hostaddr$mbrurl) and other site features requires approval by site Administrator.";
        print MAIL " Meanwhile, please verify your email address using the following verification code:\n\n";
        print MAIL "             $r{'openbalance'}\n\n";
        print MAIL "In order to verify your email address you can either use the following link :\n\n";
        print MAIL "$hostaddr"."$cgiurl?accid=$r{'id'}&cmd=activate&acode=$r{'openbalance'}\n\n";
        print MAIL "or enter the activation code into activation form at ";
        print MAIL "$hostaddr"."$cgiurl (you will need to login first)\n\n";
      }
      print MAIL "Thanks for joining us,\n$payname\n\n";
      close(MAIL);
      if ($INPUT{'confirmurl'} eq undef) {
        if ($VARS{'manual'} eq undef) {
          formactivate("Congratulations! You set up an account with us.<br>Your Account Activation code was sent to $r{'email'}.");
        } else {
          my $str = "Congratulations! You set up an account with us.<br><br>Access to Member Area and other site features requires approval by site Administrator.";
          if ($reqemail) {
            $str .= "<br><br>Your email address verification code was sent to $r{'email'}";
          }
          formactivate($str);
        }
      } else {
        confirm();
      }
    } else {
      header();
      errorpage("Unable to start mailing program. Please notify <a href=\"mailto:$adminemail\">Administrator</a>");
      footer();
    }
  } else {
    if ($INPUT{'confirmurl'} eq undef) { formmain("Congratulations! You have set up an account with us."); return;}
    else { confirm(); return; }
  }
}
#============================================================================ formaccntopen

sub formaccntopen {
  if ($INPUT{'template'} ne undef) { loadtmpl($_[0]); return; }
  &header;
  my $rq = "<font color=\"red\"><sup>*</sup></font>";
  my $msg = $_[0];
  if ($msg ne undef) { $msg = "<font color=red><b>$msg</b></color><br><br>"; }
  cmlprint("<form method=\"POST\" action=\"$cgiurl\">\n");
  cmlprint("<input type=\"image\" name=\"cmdmain\" src=\"$VARS{'imgdirurl'}/cmdcancel.gif\" border=\"0\" width=\"50\" height=\"20\" alt=\"Cancel\">");
  stlprint("<table border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\"><tr><td>");
  stlprint("<center><b>Registration Form</b></center></td></tr></table>\n\n");
  cmlprint("\n\n");
  bodyprint("</form><br><br><center>$msg\n");
  bodyprint("<font color=\"red\"><sup>*</sup></font> - required field<br><table width=\"80%\">\n");
  bodyprint("<tr><td width=\"25%\"><form method=\"POST\" action=\"$cgiurl\">\n");
  bodyprint("<input type=\"hidden\" name=\"cmd\" value=\"accntopen\">\n");
  bodyprint("<td></td><td width=\"50%\"></td></tr>");
  my $strid = "Account ID:";
  $strid = "Email Address:" if $VARS{'emailid'} ne undef;
  bodyprint("<tr><td></td><td><b>$strid$rq</b></td><td><input type=\"text\" name=\"accid\" size=\"25\" value=\"$INPUT{'accid'}\"></td></tr>\n");
  bodyprint("<tr><td></td><td><b>Password:$rq</b></td><td><input type=\"password\" name=\"cuspasswd\" size=\"25\" value=\"$INPUT{'cuspasswd'}\"></td></tr>\n");
  bodyprint("<tr><td></td><td><b>Repeat password:$rq</b></td><td><input type=\"password\" name=\"cuspasswd1\" size=\"25\" value=\"$INPUT{'cuspasswd1'}\"></td></tr>\n");
  if ($VARS{'emailid'} eq undef) {
    bodyprint("<tr><td></td><td><b>E-mail:");
    if ($reqemail) { bodyprint($rq); }
    bodyprint("</b></td><td><input type=\"text\" name=\"email\" size=\"25\" value=\"$INPUT{'email'}\"></td></tr>\n");
  }
  bodyprint("<tr><td></td><td colspan=\"2\"><center><hr></center></td></tr>\n");
  my $rqaddr = $rq if $VARS{'rqaddr'} ne undef;
  bodyprint("<tr><td></td><td><b>First name$rqaddr:</b></td><td><input type=\"text\" name=\"name\" size=\"25\" value=\"$INPUT{'name'}\"></td></tr>\n");
  bodyprint("<tr><td></td><td><b>Last name$rqaddr:</b></td><td><input type=\"text\" name=\"lname\" size=\"25\" value=\"$INPUT{'lname'}\"></td></tr>\n");
  if ($cmpladdr) {
    bodyprint("<tr><td></td><td><b>Street address$rqaddr:</b></td><td><input type=\"text\" name=\"street\" size=\"25\" value=\"$INPUT{'street'}\"></td></tr>\n");
  }
  bodyprint("<tr><td></td><td><b>City$rqaddr:</b></td><td><input type=\"text\" name=\"city\" size=\"25\" value=\"$INPUT{'city'}\"></td></tr>\n");
  bodyprint("<tr><td></td><td><b>State$rqaddr:</b></td><td><input type=\"text\" name=\"state\" size=\"25\" value=\"$INPUT{'state'}\"></td></tr>\n");
  bodyprint("<tr><td></td><td><b>ZIP$rqaddr:</b></td><td><input type=\"text\" name=\"zip\" size=\"25\" value=\"$INPUT{'zip'}\"></td></tr>\n");
  bodyprint("<tr><td></td><td><b>Country$rqaddr:</b></td><td><input type=\"text\" name=\"country\" size=\"25\" value=\"$INPUT{'country'}\"></td></tr>\n");
  if ($cmpladdr) {
    bodyprint("<tr><td></td><td><b>Phone:</b></td><td><input type=\"text\" name=\"phone\" size=\"25\" value=\"$INPUT{'phone'}\"></td></tr>\n");
    bodyprint("<tr><td></td><td><b>Fax:</b></td><td><input type=\"text\" name=\"fax\" size=\"25\" value=\"$INPUT{'fax'}\"></td></tr>\n");
  }
  bodyprint("<tr><td></td><td colspan=\"2\"><center><hr></center></td></tr>\n");
  my $customcnt=0;

  for (my $i=0; $i < 10; $i++) {
    next if $VARS{"custom$i"} eq undef;
    next if $VARS{"custom$i"."edit"} eq undef;
    $customcnt++;
    bodyprint("<tr><td></td><td><b>".$VARS{"custom$i"});
    bodyprint($rq) if $VARS{"custom$i"."rq"} ne undef;
    bodyprint("</b></td>\n<td>");
    my $type = $VARS{"custom$i"."type"};
    if ($type eq 'select') {
      bodyprint("<select name=custom$i>\n<option>$plsseltag\n");
      my @list = split(/;/,$VARS{"custom$i"."list"});
      foreach my $option (@list) {
        bodyprint("<option");
        bodyprint(" selected") if $INPUT{"custom$i"} eq $option;
        bodyprint(">$option\n");
      }
      bodyprint("</select>\n");
    } elsif ($type eq 'checkbox') {
      my $checked = 'checked' if $INPUT{"custom$i"} ne undef;
      bodyprint("<input type=checkbox name=custom$i $checked>\n");
    } else {
      bodyprint("<input type=text name=custom$i size=25 value=\"".$INPUT{"custom$i"}."\">\n");
    }
    bodyprint("</td></tr>\n");
  }
  bodyprint("<tr><td></td><td colspan=\"2\"><center><hr></center></td></tr>\n") if $customcnt;
  bodyprint("<tr><td></td><td></td><td><input type=\"submit\" value=\"Apply\"></td></tr></form></table></center>\n\n");
  &footer;
}
#============================================================================ accedit

sub accedit {
  &header;
  my $deact=0;
  my %r = accutil::getaccnt($accid);
  if (!%r) {
    formeditaccnt(accutil::error());
    return;
  }
  if ($VARS{'emailid'} eq undef) {
    if ($reqemail) {
      if ($INPUT{'email'} eq undef) {
        formeditaccnt("Missing email address");
        return;
      }
      if ($INPUT{'email'} ne $r{'email'}) {
        $deact = 1;
        srand(time());
        $r{'openbalance'} = int(rand(1000000)) + 1;
        $r{'newemail'} = $INPUT{'email'};
      }
    } else {
      $r{'email'} = $INPUT{'email'};
    }
  } else {
    $r{'email'} = $accid;
  }
  $r{'name'} = $INPUT{'name'};
  $r{'lname'} = $INPUT{'lname'};
  $r{'street'} = $INPUT{'street'};
  $r{'city'} = $INPUT{'city'};
  $r{'state'} = $INPUT{'state'};
  $r{'zip'} = $INPUT{'zip'};
  $r{'country'} = $INPUT{'country'};
  $r{'phone'} = $INPUT{'phone'};
  $r{'fax'} = $INPUT{'fax'};
  $r{'notes'} = $INPUT{'notes'};
  for (my $i=0; $i < 10; $i++) {
    next if $VARS{"custom$i"} eq undef || $VARS{"custom$i"."edit"} eq undef;
    $r{"custom$i"} = $INPUT{"custom$i"};
    next if $VARS{"custom$i"."rq"} eq undef;
    if ($r{"custom$i"} eq undef || $r{"custom$i"} eq $plsseltag) {
      formeditaccnt("Missing required field: ".$VARS{"custom$i"}); return;
    }
  }
  my $s = $INPUT{'cuspasswd'};
  if ($s ne undef) {
    if (length($s) < 6){
      formeditaccnt("Password must be 6 or more characters");
      return;
    } elsif ($s =~ /\W/) {
      formeditaccnt("Password must contain alphanumeric characters only");
      return;
    } elsif ($s ne $INPUT{'cuspasswd1'}) {
      formeditaccnt("Passwords do not match");
      return;
    }
    $r{'passwd'} = $s;
  }
  if (!accutil::editaccnt(%r)) {
      formeditaccnt(accutil::error());
      footer();
      return;
  }
  $INPUT{'accid'} = $r{'id'};
  if ($deact) {
    if (open(MAIL, "|$mailer -t")) {
      print MAIL "To: $r{'newemail'}\n";
      print MAIL "From: \"$VARS{'payname'}\" <$VARS{'payemail'}>\n";
      print MAIL "Subject: Your email address Verification Code\n\n";
      my $subscriber = "subscriber";
      if ($r{'name'} ne undef) { $subscriber="$r{'name'} $r{'lname'}"; }
      print MAIL "Dear $subscriber\n\n";
      print MAIL "Recently you have changed your email address. To apply the change we need this new address to be confirmed.\n\n";
      print MAIL "Your email address Verification Code: $r{'openbalance'}\n\n";
      print MAIL "In order to verify your new email address $r{'newemail'} you can either use the following link :\n\n";
      print MAIL "$hostaddr"."$cgiurl?accid=$r{'id'}&cmd=activate&acode=$r{'openbalance'}\n\n";
      print MAIL "or enter the Code into verification form at ";
      print MAIL "$hostaddr"."$cgiurl (you will need to login first)\n\n";
      print MAIL "Thanks for joining us,\n$payname\n\n";
      close(MAIL);
      formactivate("Your account updated.<br>To apply email address change please verify your new address.<br><br>Your email address Verification Code sent to $r{'newemail'}");
    } else {
      header();
      errorpage("Unable to start mailing program. Please notify <a href=\"mailto:$adminemail\">Administrator</a>");
      footer();
    }
  } else {
    formmain("Your account info updated.");
  }
}
#============================================================================ formeditaccnt

sub formeditaccnt {
  &header;
  my $msg = $_[0];
  if ($msg ne undef) { $msg = "<font color=red><b>$msg</b></color><br><br>"; }
  if ($accid eq undef) {
    errorpage("No account selected");
    &footer;
    return;
  }
  my %r = accutil::getaccnt($accid);
  if (!%r) {
    errorpage(accutil::error());
    &footer;
    return;
  }
  cmlprint("<form method=\"POST\" action=\"$cgiurl\">\n");
  cmlprint("<input type=\"hidden\" name=\"sid\" value=\"$sid\">");
  cmlprint("<input type=\"hidden\" name=\"accid\" value=\"$accid\">");
  cmlprint("<input type=\"hidden\" name=\"view\" value=\"$INPUT{'view'}\">");
  cmlprint("<input type=\"image\" name=\"cmdmain\" src=\"$VARS{'imgdirurl'}/cmdcancel.gif\" border=\"0\" width=\"50\" height=\"20\" alt=\"Back to accounts list\">");
  stlprint("<table border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\"><tr><td>");
  stlprint("<center><b>Updating an account</b></center></td></tr></table>\n\n");
  cmlprint("\n\n");
  bodyprint("</form><br><br><center>$msg<table width=\"80%\">\n");
  bodyprint("<tr><td width=\"25%\"><form method=\"POST\" action=\"$cgiurl\">\n");
  bodyprint("<input type=\"hidden\" name=\"cmd\" value=\"accedit\">\n");
  bodyprint("<input type=\"hidden\" name=\"sid\" value=\"$sid\">\n");
  bodyprint("<input type=\"hidden\" name=\"accid\" value=\"$INPUT{'accid'}\"></td>\n");
  bodyprint("<td></td><td width=\"50%\"></td></tr>");
  bodyprint("<tr><td></td><td><b>Account ID:</b></td><td>$accid</td></tr>\n");
  bodyprint("<tr><td></td><td colspan=\"2\"><center><hr>Leave password fields blank to preserve current password</center></font></td></tr>\n");
  bodyprint("<tr><td></td><td><b>Password:</b></td><td><input type=\"password\" name=\"cuspasswd\" size=\"25\"></td></tr>\n");
  bodyprint("<tr><td></td><td><b>Reenter password:</b></td><td><input type=\"password\" name=\"cuspasswd1\" size=\"25\"></td></tr>\n");
  if ($VARS{'emailid'} eq undef) {
    $r{'email'} = $INPUT{'email'} if $INPUT{'email'} ne undef;
    bodyprint("<tr><td></td><td><b>E-mail:</b></td><td><input type=\"text\" name=\"email\" size=\"25\" value=\"$r{'email'}\"></td></tr>\n");
  }
  bodyprint("<tr><td></td><td colspan=\"2\"><center><hr></center></td></tr>\n");
  $r{'name'} = $INPUT{'name'} if $INPUT{'name'} ne undef;
  $r{'name'} =~ s/\"/&quot;/g;
  bodyprint("<tr><td></td><td><b>First name:</b></td><td><input type=\"text\" name=\"name\" size=\"25\" value=\"$r{'name'}\"></td></tr>\n");
  $r{'lname'} = $INPUT{'lname'} if $INPUT{'lname'} ne undef;
  $r{'lname'} =~ s/\"/&quot;/g;
  bodyprint("<tr><td></td><td><b>Last name:</b></td><td><input type=\"text\" name=\"lname\" size=\"25\" value=\"$r{'lname'}\"></td></tr>\n");
  if ($cmpladdr) {
    $r{'street'} = $INPUT{'street'} if $INPUT{'street'} ne undef;
    $r{'street'} =~ s/\"/&quot;/g;
    bodyprint("<tr><td></td><td><b>Street address:</b></td><td><input type=\"text\" name=\"street\" size=\"25\" value=\"$r{'street'}\"></td></tr>\n");
  }
  $r{'city'} = $INPUT{'city'} if $INPUT{'city'} ne undef;
  $r{'city'} =~ s/\"/&quot;/g;
  bodyprint("<tr><td></td><td><b>City:</b></td><td><input type=\"text\" name=\"city\" size=\"25\" value=\"$r{'city'}\"></td></tr>\n");
  $r{'state'} = $INPUT{'state'} if $INPUT{'state'} ne undef;
  $r{'state'} =~ s/\"/&quot;/g;
  bodyprint("<tr><td></td><td><b>State:</b></td><td><input type=\"text\" name=\"state\" size=\"25\" value=\"$r{'state'}\"></td></tr>\n");
  $r{'zip'} = $INPUT{'zip'} if $INPUT{'zip'} ne undef;
  bodyprint("<tr><td></td><td><b>ZIP:</b></td><td><input type=\"text\" name=\"zip\" size=\"25\" value=\"$r{'zip'}\"></td></tr>\n");
  $r{'country'} = $INPUT{'country'} if $INPUT{'country'} ne undef;
  $r{'country'} =~ s/\"/&quot;/g;
  bodyprint("<tr><td></td><td><b>Country:</b></td><td><input type=\"text\" name=\"country\" size=\"25\" value=\"$r{'country'}\"></td></tr>\n");
  if ($cmpladdr) {
    $r{'phone'} = $INPUT{'phone'} if $INPUT{'phone'} ne undef;
    bodyprint("<tr><td></td><td><b>Phone:</b></td><td><input type=\"text\" name=\"phone\" size=\"25\" value=\"$r{'phone'}\"></td></tr>\n");
    $r{'fax'} = $INPUT{'fax'} if $INPUT{'fax'} ne undef;
    bodyprint("<tr><td></td><td><b>Fax:</b></td><td><input type=\"text\" name=\"fax\" size=\"25\" value=\"$r{'fax'}\"></td></tr>\n");
  }
  bodyprint("<tr><td></td><td colspan=\"2\"><center><hr></center></td></tr>\n");
  my $customcnt=0;
  for (my $i=0; $i < 10; $i++) {
    next if $VARS{"custom$i"} eq undef;
    next if $VARS{"custom$i"."view"} eq undef;
    $customcnt++;
    bodyprint("<tr><td></td><td><b>".$VARS{"custom$i"}.":</b></td>\n<td>");
    if ($VARS{"custom$i"."edit"} eq undef) {
      bodyprint($r{"custom$i"});
    } else {
      my $type = $VARS{"custom$i"."type"};
      $INPUT{"custom$i"} = $r{"custom$i"} if $INPUT{"custom$i"} eq undef;
      if ($type eq 'select') {
        bodyprint("<select name=custom$i>\n<option>$plsseltag\n");
        my @list = split(/;/,$VARS{"custom$i"."list"});
        foreach my $option (@list) {
          bodyprint("<option");
          bodyprint(" selected") if $INPUT{"custom$i"} eq $option;
          bodyprint(">$option\n");
        }
        bodyprint("</select>\n");
      } elsif ($type eq 'checkbox') {
        my $checked = 'checked' if $INPUT{"custom$i"} ne undef;
        bodyprint("<input type=checkbox name=custom$i $checked>\n");
      } else {
        bodyprint("<input type=text name=custom$i size=25 value=\"".$INPUT{"custom$i"}."\">\n");
      }
      bodyprint("</td></tr>\n");
    }
  }
  bodyprint("<tr><td></td><td colspan=\"2\"><center><hr></center></td></tr>\n") if $customcnt;
  bodyprint("<tr><td></td><td></td><td><input type=\"submit\" value=\"Update Account\"></td></tr></form></table></center>\n\n");
  &footer;
}
#============================================================================ formmain

sub formmain {
  my $msg = $_[0];
  if ($msg ne undef) { $msg = "<font color=red><b>$msg</b></font><br><br>"; }
  &header;
  my %r = accutil::getaccnt($accid);
  if (!%r) {
    errorpage(accutil::error());
    &footer;
    return;
  }
  stlprint("<table border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\"><tr>");
  stlprint("<td width=\"40%\"><b>&nbsp;$accid</b></td>");
  stlprint("<td><center>Main Menu</center></td>");
  stlprint("<td width=\"40%\">&nbsp;</font></td></tr></table>\n\n");
  cmlprint("<table border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\"><tr>");
  cmlprint("<form method=\"POST\" action=\"$cgiurl\"><td width=\"710\" valign=\"top\">");
  cmlprint("<input type=\"hidden\" name=\"sid\" value=\"$sid\">");
  cmlprint("<input type=\"hidden\" name=\"accid\" value=\"$accid\">");
  cmlprint("<input type=\"image\" name=\"cmdmain\" src=\"$VARS{'imgdirurl'}/cmdmain.gif\" border=\"0\" width=\"50\" height=\"20\" alt=\"Main page\">\n");
  if (!accutil::verifiednew(%r)) {
    my $type = 'Verify Email Address';
    $type = 'Activate an Account' if $VARS{'manual'} eq undef && !accutil::enabled(%r);
    cmlprint("<input type=\"image\" name=\"cmdactivate\" src=\"$VARS{'imgdirurl'}/cmdactv.gif\" border=\"0\" width=\"50\" height=\"20\" alt=\"$type\">\n");
  }
  cmlprint("<input type=\"image\" name=\"cmdedit\" src=\"$VARS{'imgdirurl'}/cmdedit.gif\" border=\"0\" width=\"50\" height=\"20\" alt=\"Edit account data\">\n");
  cmlprint("</td><td width=\"50\" valign=\"top\"><input type=\"image\" name=\"cmdlogoff\" src=\"$VARS{'imgdirurl'}/cmdlogoff.gif\" border=\"0\" width=\"50\" height=\"20\" alt=\"Logoff\"></td>\n");
  cmlprint("</tr></table>\n\n");
  bodyprint("</form>\n");
  bodyprint("<br><br><center>$msg");
  if (accutil::enabled(%r)) {
    bodyprint("<b>Your subscription is active</b><br><br>\n");
    bodyprint("<b>Go to </b><a href=\"$mbrurl\"><b>Members Area</b></a><br>\n");
  } elsif ($r{'banby'} ne undef) {
    bodyprint("<b>Your account disabled");
    if ($r{'banreason'} ne undef) {
      bodyprint("<br>Reason: $r{'banreason'}</b><br><br>\n");
    }
    bodyprint("<br><br>Please contact <a href=\"mailto:$VARS{'payemail'}\">$VARS{'payname'}</a> for more info.<br><br>\n");
  } else {
    bodyprint("<b>Your subscription is inactive</b>");
    if ($VARS{'reqemail'} ne undef && !accutil::verifiednew(%r)) {
      bodyprint("<br>Please <a href=\"$cgiurl?sid=$sid&accid=$accid&cmd=activate\">verify your email address</a> (check your mailbox for an activation code)\n");
    } elsif ($VARS{'manual'} ne undef) {
      bodyprint("<br>Awaiting manual approval");
    }
    bodyprint("<br><br>Please contact <a href=\"mailto:$VARS{'payemail'}\">$VARS{'payname'}</a> for more info.<br><br>\n");
  }
  bodyprint("<center>\n\n");
  &footer;
}
#============================================================================ logoff

sub logoff {
  if ($accid ne undef) {
    my $f = "$siddir/$accid";
    if (-e $f) { unlink($f); }
  }
  loginform();
}
#============================================================================ login

sub login {
  if ($accid eq undef) { loginform("Missing account id"); exit; }
  my %r = accutil::getaccnt($accid);
  if (!%r || ($r{'passwd'} ne $INPUT{'passwd'})) {
    loginform("Wrong password");
    exit;
  }
  srand(time());
  $sid = int(rand(1000000));
  my $f = "$siddir/$accid";
  if (!open(SIDF, ">$f")) { errexit("Unable create customer session"); }
  flock(SIDF, $LOCK_EX) if $LOCK_EX;
  print SIDF "$sid\n";
  close(SIDF);
  $cmd='gomain';
}
#============================================================================ checksid

sub checksid {
  my $f = "$siddir/$accid";
  if (! -e $f) { return 0; }
  if (!open(SIDF, $f)) { return 0; }
  flock(SIDF, $LOCK_EX) if $LOCK_EX;
  my $s = <SIDF>;
  close(SIDF);
  chop($s);
  if ($s eq $sid) { return 1; }
  return 0;
}
#============================================================================ header

sub header {
if ($headeron) { return; }
print<<EOF;
<HTML>\n
<HEAD><TITLE>My Account</TITLE>
<link rel=stylesheet href=$VARS{'imgdirurl'}/styles.css type=text/css>
</HEAD>\n
<body bgcolor="$VARS{'bodycolor'}">
<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"760\"><tr><td>
<table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
EOF
$headeron=1;
my $header_file = "$basedir/tmpl/header.txt";
if (-e $header_file) {
        if (open(HDR, "<$header_file")) {
                my @lines = <HDR>;
                close(HDR);
                print "<tr><td>\n";
                print @lines;
                return;
                print "</td></tr>\n";
        }
}
}
#============================================================================ footer

sub footer {
my $footer_file = "$basedir/tmpl/footer.txt";
if ($debug) {
  print "<tr><td>";
  my $tm = time() - $starttime;
  my ($utm, $stm) = (times())[0, 1];
  print "Run time = $tm, user = $utm, system = $stm</br>";
  foreach my $key (sort keys (%INPUT)) {
    print "$key: $INPUT{$key}<br>\n";
  }
  print "<p>VARS:</br>\n";
  foreach my $key (sort keys (%VARS)) {
    print "$key: $VARS{$key}<br>\n";
  }
  accutil::debug();
  print "</td></tr>";
}
if (-e $footer_file) {
        if (open(FTR, "<$footer_file")) {
                my @lines = <FTR>;
                close(FTR);
                print "<tr><td>\n";
                print @lines;
                print "<p><font size=-2>RegisterMe! (c) - 2000-02, <a href=\"http://www.eastwright.com/internet/\">Eastwright Corp.</font></a><br>";
                print "</td></tr></table></td></tr></table></BODY></HTML>\n";
                return;
        }
} else {
  print "<tr><td><br><table width=\"100%\" border=0><tr><td><hr></td></tr><tr><td>";
  print "<p><p><font size=-2>RegisterMe! (c) - 2000-02, <a href=\"http://www.eastwright.com/internet/\">Eastwright Corp.</a><br>";
  print "Support: <A HREF=\"mailto:$adminemail\">$adminemail</A><br>";
  print "Version: $version $package";
  print "</font></td></tr></table></td></tr></table></td></tr></table></BODY></HTML>\n";
}
}
#============================================================================ bodyprint

sub bodyprint {
  my $line = $_[0];
  $line =~ s/\<td/<td bgcolor=\"$VARS{'bodycolor'}\" valign=\"top\"/g;
  if (!@bodylines) {
    push @bodylines, "<tr><td bgcolor=\"$VARS{'bodycolor'}\">";
  }
  push @bodylines, $line;
  if ($line =~ /\n\n/) {
    while (@bodylines) { print shift @bodylines; }
    print "</td></tr>";
  }
}
#============================================================================ cmlprint

sub cmlprint {
  my $line = $_[0];
  $line =~ s/\<td/<td bgcolor=\"$VARS{'cmdcolor'}\"/g;
   if (!@cmdline) {
    push @cmdline, "<tr><td bgcolor=\"$VARS{'cmdcolor'}\">";
  }
  push @cmdline, $line;
  if ($line =~ /\n\n/) {
    while (@cmdline) { print shift @cmdline; }
    print "</td></tr>";
  }
}
#============================================================================ stlprint

sub stlprint {
  my $line = $_[0];
  $line =~ s/\<td/<td bgcolor=\"$VARS{'stlcolor'}\"/g;
  if (!@statusline) {
    push @statusline, "<tr><td bgcolor=\"$VARS{'stlcolor'}\">";
  }
  push @statusline, $line;
  if ($line =~ /\n\n/) {
    while (@statusline) { print shift @statusline; }
    print "</td></tr>";
  }
}
#============================================================================ errexit

sub errexit {
print <<EOT;
<html><head></head><body>
<center><br><font size=+1 color=red><b>
Fatal Error: $_[0]. Execution aborted...
</b></font></center>
</body></html>
EOT
exit;
}
#============================================================================ findcgidir

sub findcgidir {
  my $scriptfilename = $ENV{'SCRIPT_FILENAME'};
  $scriptfilename = $ENV{'PATH_TRANSLATED'} if $ENV{'PATH_TRANSLATED'} ne undef;
  if ($scriptfilename eq undef) {
    if ($ENV{'PWD'} ne undef) {
      my @parts = split(/\//, $ENV{'SCRIPT_NAME'});
      my $f = pop @parts;
      $scriptfilename = "$ENV{'PWD'}/$f";
    }
  }
  my @cgipath = split(/\//, $scriptfilename);
  pop(@cgipath);
  $cgidir = join("\/", @cgipath);
}
#============================================================================ loadcgf

sub loadcfg {
  my @buff;
  my $line;
  if (! open(CFG, $cfgfile)) { return 0; }
  @buff = <CFG>;
  close(CFG);
  chomp(@buff);
  foreach $line (@buff) {
    my $name;
    my $value;
    ($name, $value) = split(/=/, $line);
    if ($value ne undef) { $VARS{$name} = $value; }
  }
  $basedir = $VARS{'basedir'};
  $siddir = $VARS{'siddir'};
  $adminemail = $VARS{'adminemail'};
  $mailer = $VARS{'mailer'};
  my $uselock = $VARS{'uselock'};
  $payname = $VARS{'payname'};
  $singleuser = $VARS{'singleuser'};
  $payemail = $VARS{'payemail'};
  $cmpladdr = $VARS{'cmpladdr'};
  $reqemail = $VARS{'reqemail'};
  $mbrdir = $VARS{'mbrdir'};
  $mbrurl = $VARS{'mbrurl'};
  $hostaddr = $VARS{'hostaddr'};
  $VARS{'bodycolor'} = '#fcfceb' if $VARS{'bodycolor'} eq undef;
  $VARS{'cmdcolor'} = '#b5cc94' if $VARS{'cmdcolor'} eq undef;
  $VARS{'stlcolor'} = '#fff0cf' if $VARS{'stlcolor'} eq undef;
  &accutil::init(%VARS);
  if ($uselock) { $LOCK_EX = "2"; }
  return 1;
}
#============================================================================ loginform

sub loginform {
  my $msg = $_[0];
  if ($msg ne undef) { $msg = "<font color=red><b>$msg</b></color><br><br>"; }
  &header;
  stlprint("<center>Customer Login</center>\n\n");
  cmlprint("&nbsp;\n\n");
  bodyprint("<center><br><br>$msg<table><tr><td align=right><form method=\"POST\" action=\"$cgiurl\">");
  my $idtitle = 'User ID';
  $idtitle = 'Email Address' if $VARS{'emailid'} ne undef;
  bodyprint("<b>$idtitle:</b></td><td><input type=\"text\" size=\"25\" name=\"accid\" value=\"$INPUT{'accid'}\"></td></tr>");
  bodyprint("<td align=right><b>Password:</td><td><input type=\"password\" size=\"25\" name=\"passwd\"></td></tr>");
  bodyprint("<tr><td><input type=\"hidden\" name=\"cmd\" value=\"login\"></td><td>");
  bodyprint("<input type=\"submit\" value=\"Login\"></form>");
  if ($VARS{'nonewlink'} eq undef) {
    bodyprint("<a href=\"$cgiurl?cmd=formaccntopen\">Register Now!</a><br><br>\n");
  }
  bodyprint("<a href=\"$cgiurl?cmd=formlostpasswd\">Password Finder</a></td></tr></table>\n\n");
  &footer;
}
#============================================================================ errorpage
# errorpage($err)
# does not print header & footer

sub errorpage {
  my $e = $_[0];
  cmlprint("<form method=\"POST\" action=\"$cgiurl\">\n");
  cmlprint("<input type=\"hidden\" name=\"sid\" value=\"$sid\">");
  cmlprint("<input type=\"hidden\" name=\"accid\" value=\"$accid\">");
  cmlprint("<input type=\"image\" name=\"cmdmain\" src=\"$VARS{'imgdirurl'}/cmdcancel.gif\" border=\"0\" width=\"50\" height=\"20\" alt=\"Back to accounts list\">");
  stlprint("<table border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\"><tr><td>");
  stlprint("<center><font color=red><b>Error</b></font></center></td></tr></table>\n\n");
  cmlprint("\n\n");
  bodyprint("</form><br><br><center><b>Error: $e</b></center><br><br>\n\n");
}