package accutil;
require HTMLMailer;

use strict;


my $htpasswdname='.htpasswd';
my $htaccessname='.htaccess';


my $version = '3.04';
my $accfname = "accdata.cgi";
my $sidsubdirname = 'sid';
my $lupdfname = "lastaccupd.dat";
my $configoverridename = "configoverride.cgi";
my $accnumfname = "accnum.dat";
my ($mailer, $reqemail);
my ($payemail, $payname);
my ($hostaddr, $accviewpl);

my ($basedir, $htpasswddir, $siddir, $mbrdir, $mbrurl);
my $perlpath;
my $LOCK_EX;

my $accdb;
my $lasterror;
my %CURREC;
my %VARS;
my @rawrec;

#======================================================================= autoban

sub autoban {
# ===LITE===
}
#================================================================ configoverride

sub configoverride {
  return $configoverridename;
}
#===================================================================== sidsubdir

sub sidsubdir {
  return $sidsubdirname;
}
#====================================================================== htpasswd

sub htpasswd {
  return $htpasswdname;
}
#====================================================================== htaccess

sub htaccess {
  return $htaccessname;
}
#======================================================================= cfgfile

sub cfgfile {
  my $f = "config.cgi";
  if (-e $configoverridename && open(OVRD, $configoverridename)) {
    $f = <OVRD>;
    chomp($f);
    close OVRD;
  }
  return $f;
}

#================================================================ massmail
# massmail(subj, msg, view, from, html)

sub massmail {
# ===LITE===
  return 1;
}
#================================================================ accntfields

sub accntfields {
  my @fields = ('id', 'passwd', 'opendate', 'openbalance', 'name', 'lname', 'street',
               'city', 'state', 'zip', 'country', 'phone', 'fax', 'email', 'approved',
               'newemail', 'verified', 'banby', 'banreason', 'notes',
               'bizphone', 'custom1', 'custom2',
               'custom0', 'custom3',
               'custom4', 'custom5', 'custom6', 'custom7', 'custom8', 'custom9');
  return @fields;
}
#================================================================ rec2line

sub rec2line {
  my %REC = @_;
  my $line;
  my @names = accntfields();
  foreach my $name (@names) {
    if ($name ne $names[0]) {
      $line .= ":" if $name ne $names[0];
      $REC{$name} =~ s/:/&Colon;/g;
    }
    $line .= $REC{$name};
  }
  $line =~ s/>/&gt;/g;
  $line =~ s/</&lt;/g;
  return $line;
}
#================================================================ line2rec

sub line2rec {
  my %r;
  my @fields = split(/:/, $_[0]);
  my @names = accntfields();
  foreach my $name (@names) {
    $r{$name} = shift @fields if @fields;
    $r{$name} =~ s/&Colon;/:/g;
  }
  return %r;
}
#================================================================ getlastupd

sub getlastupd {
  if (!open(UPD, "<$basedir/$lupdfname")) { return time(); }
  flock(UPD, $LOCK_EX) if $LOCK_EX;
  my $line = <UPD>;
  close(UPD);
  chop($line);
  return $line;
}

#================================================================ setlastupd

sub setlastupd {
  my $line = time();
  if (open(UPD, ">$basedir/$lupdfname")) {
    flock(UPD, $LOCK_EX) if $LOCK_EX;
    print UPD "$line\n";
    close(UPD);
  }
}

#================================================================ accauto

sub accauto {
  if ($VARS{'emailid'} ne undef) {
    $lasterror = "Auto accounts feature disabled (email IDs feature is ON)";
    return 0;
  }
  my $f = "$basedir/$accnumfname";
  if (! -e $f) {
    if (!open(ACCNUM, ">$f")) {
      $lasterror = "Failed to create auto accounts file";
      return 0;
    }
    flock(ACCNUM, $LOCK_EX) if $LOCK_EX;
    print ACCNUM "0\n";
    close(ACCNUM);
  }
  if (!open(ACCNUM, "+<$f")) {
    $lasterror = "Failed to open auto accounts file";
    return 0;
  }
  flock(ACCNUM, $LOCK_EX) if $LOCK_EX;
  my $n = <ACCNUM>;
  chop($n);
  $n++;
  seek(ACCNUM, 0, 0);
  print ACCNUM "$n\n";
  close(ACCNUM);
  return $n;
}

#================================================================ nextrec

sub nextrec {
  my $l = shift @rawrec;
  my %r = line2rec($l);
  return %r;
}


#================================================================ viewcnt

sub viewcnt {
  my $n = @rawrec;
  return $n;
}


#================================================================ readview
# readview ($view, $skip, $cnt) returns $view

sub readview {
  my $accsel = 0;
  my $extra = 0;
  my $fullscan = 0;
  my (%f, @rawrecbuf);
  my $view = $_[0];
  my $skip = $_[1];
  my $skipcnt = $skip;
  my $cnt = $_[2];
# print "<br>readwiew($view, $skip, $cnt)<br>";
  my @fields = split (/:/, $view);
# reccnt:lastupd:skip:pos[:ftype:key:op:val[:key1:op1:val1]]
  my $reccnt = shift @fields;
  my $lastupd = shift @fields;
  my $v_skip = shift @fields;
  my $pos = shift @fields;
  if (! -e $accdb) { $lasterror = "Account database does not exist."; return "-1"; }
  if (! open(ACC, "<$accdb")) { $lasterror="Failed to open accounts database."; return "-1"; }
  flock(ACC, $LOCK_EX) if $LOCK_EX;
  $fullscan = getlastupd() - $lastupd;
  my $line;
  if ($fullscan || $skip < $v_skip) {
    $pos = tell(ACC);
    $v_skip = 0;
  } elsif ($skip == $v_skip) {
    $skipcnt = 0;
  } else { $skipcnt = $skip - $v_skip; }
  seek(ACC, $pos, 0);
  $line = <ACC>;
  chop($line);
  while ($line ne undef) {
    my %r = line2rec($line);
    my $ok = 1;
    if ($ok) {
      if ($skipcnt) { $skipcnt--; $pos = tell(ACC);
      } else {
        if ($cnt > 0) {
          push @rawrecbuf, $line;
          $accsel++;
        }
        $cnt--;
        if (!$cnt) {
          if (!$fullscan) { last; }
        } elsif ($cnt < 0) {  $extra++; }
      }
    } elsif (!$accsel) { $pos = tell(ACC); }
    $line = <ACC>;
    chop($line);
  }
  if ($fullscan) { $reccnt = $skip + $accsel + $extra; $lastupd=&getlastupd;}
  close(ACC);
  $view = "$reccnt:$lastupd:$skip:$pos";
  @rawrec = @rawrecbuf;
  return $view;
}
#================================================================ createview
# createview ($ftype, %filter); returns $view

sub createview {
  my $view;
  my ($line, @fields, $accsel, $pos);
  if (! -e $accdb) { $lasterror = "Account database does not exist."; return "-1"; }
  if (! open(ACC, "<$accdb")) { $lasterror="Failed to open accounts database."; return "-1"; }
  flock(ACC, $LOCK_EX) if $LOCK_EX;
  $accsel = 0;
  $pos = tell(ACC);
  $line = <ACC>;
  chop($line);
  while ($line ne undef) {
    my %r = line2rec($line);
    $accsel++;
    $line = <ACC>;
    chop($line);
  }
  my $tm = &getlastupd;
  close(ACC);
  $view="$accsel:$tm:0:$pos";
  return $view;
}
#================================================================ editaccnt

sub editaccnt {
  my %r = @_;
  if (!validrec(%r)) { return 0; }
  my $id = $r{'id'};
  if (! -e $accdb) { $lasterror = "Account database does not exist."; return 0; }
  my $tmpfile = "$accdb.tmp";
  if (! open(TMP, "+>$tmpfile")) { $lasterror="Failed to create temporary file."; return 0; }
  flock(TMP, $LOCK_EX) if $LOCK_EX;
  if (! open(ACC, "+<$accdb")) {
    $lasterror="Failed to open accounts database.";
    close(TMP);
    return 0;
  }
  flock(ACC, $LOCK_EX) if $LOCK_EX;
# skip header
  my ($wpos, $line, $curid);
# skip to record to replace
  do {
    $wpos = tell(ACC);
    $line = <ACC>;
    chop($line);
    ($curid) = (split (/:/, $line))[0];
  } while ($line ne undef && $curid ne $id);
  if ($line eq undef) {
    $lasterror="Account $id does not exist.";
    close(TMP);
    close(ACC);
    return 0;
  }
#duplicate trailing records into temporary file
  $line = <ACC>;
  chop($line);
  while ($line ne undef) {
    print TMP "$line\n";
    $line = <ACC>;
    chop($line);
  }
  truncate (TMP, tell(TMP));
# record the account to be updated
  seek(ACC, $wpos, 0);
  $line = rec2line(%r);
  print ACC "$line\n";
# copy trailing records from temporary file
  seek(TMP, 0, 0);
  $line = <TMP>;
  while($line ne undef) {
    print ACC $line;
    $line = <TMP>;
  }
  truncate(ACC, tell(ACC));
  truncate(TMP, 0);
  close(TMP);
  close(ACC);
  setlastupd();
  my $cc;
  if (enabled(%r)) { $cc = enableaccnt(%r); }
  else { $cc = disableaccnt(%r); }
  return $cc;
}
#================================================================ delaccnt

sub delaccnt {
  my $id = $_[0];
  my ($line, $wpos, $rpos, @fields);
  if (! -e $accdb) { $lasterror = "Account database does not exist."; return 0; }
  my %r = getaccnt($id);
  if (%r) { disableaccnt(%r); }
  if (! open(ACC, "+<$accdb")) { $lasterror="Failed to open accounts database."; return 0; }
  flock(ACC, $LOCK_EX) if $LOCK_EX;
  do {
    $wpos = tell(ACC);
    $line = <ACC>;
    chop($line);
    @fields = split (/:/, $line);
  } while ($line && $fields[0] ne $id);
  if ($line eq undef) {
    $lasterror="Account $id does not exist.";
    close(ACC);
    return 0;
  }
  $line = <ACC>;
  chop($line);
  while ($line) {
    $rpos = tell(ACC);
    seek(ACC, $wpos, 0);
    print ACC "$line\n";
    $wpos = tell(ACC);
    seek(ACC, $rpos, 0);
    $line = <ACC>;
    chop($line);
  }
  truncate(ACC, $wpos);
  &setlastupd;
  close(ACC);
# void invoices
  my $ok = 1;
  unlink("$siddir/$id") if (-e "$siddir/$id");
  return $ok;
}

#================================================================ createdb

sub createdb {
  if (!-e $accdb) {
    if (! open(ACC, ">$accdb")) { $lasterror="Failed to create file $accdb."; return 0; }
    flock(ACC, $LOCK_EX) if $LOCK_EX;
print ACC <<EOT;
EOT
    &setlastupd;
    close (ACC);
  }
  chmod(0755, $accdb);
  return 1;
}


#================================================================ validrec

sub validrec {
  my %REC = @_;
  my ($key, $val);
  if ($REC{'id'} eq undef) { $lasterror = "Missing account ID."; return 0; }
  if ($REC{'id'} =~ /[^-a-zA-Z0-9_@.]/) { $lasterror = "Account ID $REC{'id'} contains non alphanumeric character(s)."; return 0; }
  if (!$REC{'passwd'}) { $lasterror = "Missing account password."; return 0; }
  if ($REC{'passwd'} =~ /\W/) { $lasterror = "Account password contains non alphanumeric character."; return 0; }
  return 1;
}

#================================================================ getaccnt
# getaccnt($id)

sub getaccnt {
  my %r;
  if (&findrecbyid($_[0])) { %r = %CURREC; }
  else { $lasterror = "Account $_[0] does not exist." }
  return %r;
}


#================================================================ findrecbyid

sub findrecbyid {
  my $line;
  my $id = $_[0];
  if (! open(ACC, "<$accdb")) { $lasterror="Failed to open accounts database."; return 0; }
  flock(ACC, $LOCK_EX) if $LOCK_EX;
  do {
    my @fields;
    $line = <ACC>;
    chop($line);
    @fields = split (/:/, $line);
    if ($fields[0] eq $id) {
      close (ACC);
      %CURREC = line2rec($line);
      return 1;
    }
  } while ($line);
  close (ACC);
  my $htpwd = "$htpasswddir/$htpasswdname";
  if (open(PWD,"<$htpwd")) {
    flock(PWD, $LOCK_EX) if $LOCK_EX;
    my @htpasswd = <PWD>;
    close(PWD);
    @htpasswd = grep(/^$id:/, @htpasswd);
    if ($htpasswd[0] ne undef) {
      %CURREC = line2rec("$id");
      return 1;
    }
  }
  return 0;
}
#================================================================ disableaccnt
# disableaccnt(%r)

sub disableaccnt {
  my %r = @_;
  if (!validrec(%r)) { return 0; }
  if (!findrecbyid($r{'id'})) { $lasterror = "Account id $r{'id'} does not exist."; return 0; }
  my $htpwd = "$htpasswddir/$htpasswdname";
  if (!open(PWD,$htpwd)) {
    open(PWD,">$htpwd");
  }
  close(PWD);
  if (open(PWD,"+<$htpwd")) {
    flock(PWD, $LOCK_EX) if $LOCK_EX;
    my @htpasswd = <PWD>;
    @htpasswd = grep(!/^$r{'id'}:/, @htpasswd);
    seek(PWD, 0, 0);
    my $line;
    foreach $line (@htpasswd) { print PWD $line; }
    truncate(PWD, tell(PWD));
    close(PWD);
  }
  return 1;
}
#================================================================ enableaccnt
# enableaccnt(%r)

sub enableaccnt {
  my %r = @_;
  if (!validrec(%r)) { return 0; }
  if (!findrecbyid($r{'id'})) { $lasterror = "Account id $r{'id'} does not exist."; return 0; }
  my $htpwd = "$htpasswddir/$htpasswdname";
  if (!open(PWD, $htpwd)) {
    open(PWD,">$htpwd");
    close(PWD);
    umask(0000);
    chmod(0766, $htpwd);
  } else {
    close PWD;
  }
  if (open(PWD,"+<$htpwd")) {
    flock(PWD, $LOCK_EX) if $LOCK_EX;
    my @htpasswd = <PWD>;
    @htpasswd = grep(!/^$r{'id'}:/, @htpasswd);
    seek(PWD, 0, 0);
    my $line;
    foreach $line (@htpasswd) { print PWD $line; }
    my $passwd = crypt($r{'passwd'}, 'aa');
    print PWD "$r{'id'}:$passwd\n";
    truncate(PWD, tell(PWD));
    close(PWD);
  }
  return 1;
}
#================================================================ addaccnt
# addaccnt(%ACCREC)
#
# id | passwd | opendate | openbalance | name | street | city | state |
# zip | country | phone | fax | email | cctype | ccnumber | ccvalid |
# ccname | cczip | notes | reserved1 | reserved2

sub addaccnt {
  my %REC = @_;
  if (!validrec(%REC)) { return 0; }
  if (-e $accdb) {
    if (findrecbyid($REC{'id'})) { $lasterror = "Account id $REC{'id'} already exists."; return 0; }
  } elsif (!createdb()) { return 0; }
  if (!open(ACC, ">>$accdb")) { $lasterror="Failed to open accounts database."; return 0; }
  flock(ACC, $LOCK_EX) if $LOCK_EX;
  seek(ACC, 0, 2);
  print ACC rec2line(%REC)."\n";
  setlastupd();
  close(ACC);
  my $cc = 1;
  if (enabled($REC{'enabled'})) { $cc = enableaccnt(%REC); }
  return $cc;
}

sub enabled {
  my %r = @_;
  my $yes = 1;
  $yes = 0 if $r{'banby'} ne undef;
  $yes = 0 if $VARS{'manual'} ne undef && $r{'approved'} eq undef;
  $yes = 0 if $VARS{'reqemail'} ne undef && !$r{'verified'};
  return $yes;
}
sub verifiednew {
  my %r = @_;
  my $yes = 1;
  $yes = 0 if $r{'openbalance'} > 0;
  return $yes;
}

sub error {
  return $lasterror;
}

sub init {
  %VARS = @_;
  $basedir = $VARS{'basedir'};
  $siddir = $VARS{'siddir'};
  $perlpath = $VARS{'perlpath'};
  $mailer = $VARS{'mailer'};
  $payemail = $VARS{'payemail'};
  $payname = $VARS{'payname'};
  $hostaddr = $VARS{'hostaddr'};
  $accviewpl = $VARS{'accview'};
  $mbrdir = $VARS{'mbrdir'};
  $mbrurl = $VARS{'mbrurl'};
  $reqemail = $VARS{'reqemail'};
  $htpasswddir = $VARS{'htpasswddir'};
  if ($VARS{'lockon'}) { $LOCK_EX = 2; }
  $accdb = "$basedir/$accfname";
}

sub getaccdbname {
  return $accdb;
}

sub debug {
 print "<p><u><b>accutil.pm debug data</b></u><br>\n";
print <<EOT;
basedir = $basedir<br>
perlpath = $perlpath<br>
EOT
}

1;