#!/usr/bin/perl
use strict;
require 5.003;
use accutil;

my $version = '3.04';
my $package = "Lite";

print "Content-type: text/html\n\n";

my $cfgfile = accutil::cfgfile();
my $plsseltag = "--- Please Select ---";
my $initstep = 20;
my $pwdfile;
my $basedir;
my $adminemail;
my $mailer;
my $debug = 0;
my $LOCK_EX;
my $cmpladdr;
my $reqemail;
my $accautoprefix = "CUS1";
my $cgidir;
my %VARS;
my $transparent;

my $starttime = time();
my $headeron = 0;
my $uselock;
my $user;
my $singleuser;
my $cmd;
my @pairs;
my $pair;
my %INPUT;
my %USRPWD;
my %USRMODE;
my %USRSID;
my %USRMAIL;
my %USRPHONE;
my %USRNAME;
my $cgiurl = $ENV{'SCRIPT_NAME'};
my $accmgrpl = $cgiurl;
my $adminpl;
my $accviewpl;
my $sid;
my $buffer;
my (@statusline, @cmdline, @bodylines);

@pairs = split(/&/, $ENV{'QUERY_STRING'});
foreach $pair (@pairs) {
        my ($name, $value);
        ($name, $value) = split(/=/, $pair);
        if ($name ne 'msg') {
          $value =~ s/%0D%0A/ /g;
          $value =~ s/%0A%0D/ /g;
        } else {
          $value =~ s/%0D%0A/\n/g;
          $value =~ s/%0A%0D/\n/g;
        }
        $value =~ tr/+/ /;
        $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
        if ($INPUT{$name}) { $INPUT{$name} = $INPUT{$name}.",".$value; }
        else { $INPUT{$name} = $value; }
}

read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
        my ($name, $value);
        ($name, $value) = split(/=/, $pair);
        if ($name ne 'msg') {
          $value =~ s/%0D%0A/ /g;
          $value =~ s/%0A%0D/ /g;
        } else {
          $value =~ s/%0D%0A/\n/g;
          $value =~ s/%0A%0D/\n/g;
        }
        $value =~ tr/+/ /;
        $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
        if ($INPUT{$name}) { $INPUT{$name} = $INPUT{$name}.",".$value; }
        else { $INPUT{$name} = $value; }
}

$cmd = $INPUT{'cmd'};
$user = $INPUT{'user'};

findcgidir();
if (!&loadcfg) { &errexit("Failed to read config file"); }
if ($cmd eq 'login') { login(); exit; }
$sid = $INPUT{'sid'};
if (!$sid) { &loginform; exit; }
if (!&checksid) { &loginform; exit; }
if ($singleuser eq 'on' && $USRMODE{$user} ne 'A') {
  loginform("Database shot down for maintenance, please try login later");
  exit;
}
if ($VARS{'version'} < 3) { upgrform(); exit; }
if ($cmd eq 'gomain') { accmgr(); exit; }
if ($cmd eq 'massmail') { massmail(); exit; }
if ($cmd eq 'accnew') { accnew(); exit; }
if ($cmd eq 'accdel') { accdel(); exit; }
if ($cmd eq 'accedit') { accedit(); exit; }
if ($cmd eq 'acctoggle') { acctoggle(); exit; }
if ($cmd eq 'setfilter') { setfilter(); exit; }
if ($cmd eq 'accmgr' || $INPUT{'accmgr.x'} ne undef) { &accmgr; exit; }
if ($INPUT{'accmgrb.x'} ne undef) {
  $INPUT{'skip'} = $INPUT{'skipb'};
  $INPUT{'step'} = $INPUT{'stepb'};
  &accmgr;
  exit;
}
if ($INPUT{'accmgrf.x'} ne undef) {
  $INPUT{'skip'} = $INPUT{'skipf'};
  $INPUT{'step'} = $INPUT{'stepf'};
  &accmgr;
  exit;
}
if ($INPUT{'cmdfilter.x'} ne undef) { formfilter(); exit; }
if ($INPUT{'cmdlogoff.x'} ne undef) { logoff(); exit; }
if ($INPUT{'cmddel.x'} ne undef) { formdelaccnt(); exit; }
if ($INPUT{'cmdnew.x'} ne undef) { formnewaccnt(); exit; }
if ($INPUT{'cmdview.x'} ne undef) { formviewaccnt(); exit; }
if ($INPUT{'cmdedit.x'} ne undef) { formeditaccnt(); exit; }
if ($INPUT{'cmdtoggle.x'} ne undef) { formtoggle(); exit; }
if ($INPUT{'cmdmail.x'} ne undef) { formmassmail(); exit; }
if ($INPUT{'cmdlog.x'} ne undef) { formlog(); exit; }

&header;
print "unknown command";
&footer;
exit;

#============================================================================ setfilter

sub setfilter {
  my %filter;
  $INPUT{'view'} = accutil::createview('and', %filter);
  $INPUT{'skip'} = 0;
  accmgr();
  return;
}
#================================================================ verifiedselector

sub verifiedselector {
  my @oper = ('none', 'gt', 'lt');
  my @name = ('-- Any value --', 'Yes', 'No');
  my $s = "<select name=\"$_[0]\">\n";
  my $i;
  for($i=0; $i<3; $i++) {
    $s .= "<option value=\"$oper[$i]\" ";
    if ($oper[$i] eq $_[1]) { $s = $s . 'selected'; }
    $s .= ">$name[$i]\n";
  }
  $s .= "</select>\n";
  return $s;
}
#================================================================ statusselector

sub statusselector {
  my @oper = ('none', 'gt', 'lt');
  my @name = ('-- Any value --', 'Active', 'Inactive');
  my $s = "<select name=\"$_[0]\">\n";
  my $i;
  for($i=0; $i<3; $i++) {
    $s = $s . "<option value=\"$oper[$i]\" ";
    if ($oper[$i] eq $_[1]) { $s = $s . 'selected'; }
    $s = $s . ">$name[$i]\n";
  }
  $s = $s . "</select>\n";
  return $s;
}
#============================================================================ operselector

sub operselector {
  if ($_[0] =~ /verified/) { return verifiedselector($_[0], $_[1]); }
  if ($_[0] =~ /status/) { return statusselector($_[0], $_[1]); }
  my @oper = ('none', 'eq', 'beg', 'has', 'emp');
  my @name = ('-- Any value --', 'equals', 'begins with', 'includes', 'is empty');
  my $s = "<select name=\"$_[0]\">\n";
  my $i;
  for($i=0; $i<5; $i++) {
    $s = $s . "<option value=\"$oper[$i]\" ";
    if ($oper[$i] eq $_[1]) { $s = $s . 'selected'; }
    $s = $s . ">$name[$i]\n";
  }
  $s = $s . "</select>\n";
  return $s;
}
#====================================================================== upgrform

sub upgrform {
  header();
  stlprint("<center><b>Please Install Upgrade</b></center></td></tr></table>\n\n");
  cmlprint("<table border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\"><tr>");
  cmlprint("<form method=\"POST\" action=\"$adminpl\"><td width=\"50\" valign=\"top\">");
  cmlprint("<input type=\"hidden\" name=\"sid\" value=\"$sid\">");
  cmlprint("<input type=\"hidden\" name=\"user\" value=\"$user\">");
  cmlprint("<input type=\"image\" name=\"cmdadmin\" src=\"$VARS{'imgdirurl'}/cmdadmin.gif\" width=\"50\" height=\"20\" border=\"0\" alt=\"Admin Interface\"></td></form></tr></table>\n\n");
  bodyprint("<center><br><b>Please install upgrade</b><br>(you must be logged in as system admin)</center>\n\n");
  footer();
}
#============================================================================ formfilter

sub formfilter {
  &header;
  my $msg = $_[0];
  $msg .= "<br><br>Set Filter Command not supported by LITE version";
  if ($msg ne undef) { $msg = "<font color=red><b>$msg</b></color><br><br>"; }
  my $view = $INPUT{'view'};
  my %filter;
  cmlprint("<form method=\"POST\" action=\"$cgiurl\">\n");
  cmlprint("<input type=\"hidden\" name=\"sid\" value=\"$sid\">");
  cmlprint("<input type=\"hidden\" name=\"user\" value=\"$user\">");
  cmlprint("<input type=\"hidden\" name=\"view\" value=\"$INPUT{'view'}\">");
  cmlprint("<input type=\"image\" name=\"accmgr\" src=\"$VARS{'imgdirurl'}/cmdcancel.gif\" border=\"0\" width=\"50\" height=\"20\" alt=\"Back to accounts list\">");
  stlprint("<table border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\"><tr><td>");
  stlprint("<center><b>Edit filter</b></center></td></tr></table>\n\n");
  cmlprint("\n\n");
  bodyprint("</form><br><br><center>$msg<table width=\"80%\">\n");
  bodyprint("<tr><td width=\"18%\"><form method=\"POST\" action=\"$cgiurl\">\n");
  bodyprint("<input type=\"hidden\" name=\"cmd\" value=\"setfilter\">\n");
  bodyprint("<input type=\"hidden\" name=\"sid\" value=\"$sid\">\n");
  bodyprint("<input type=\"hidden\" name=\"user\" value=\"$user\">\n");
  bodyprint("<input type=\"hidden\" name=\"accid\" value=\"$INPUT{'accid'}\"><b>Field</b></font></td>\n");
  bodyprint("<td width=\"25%\"><b>Operation</b></font></td><td width=\"57%\"><b>Value</b></font></td></tr>");
  my $idtitle = 'Account ID';
  $idtitle = 'Email Address' if $VARS{'emailid'} ne undef;
  my @fields = ('id', 'name', 'lname', 'city', 'state', 'country', 'email', 'verified', 'approved', 'status');
  my @names = ($idtitle, 'Name', 'Last Name', 'City', 'State', 'Country', 'Email', 'Verified', 'Approved By', 'Status');
  my $i;
  for ($i=0; $i < @fields; $i++) {
    next if $fields[$i] eq 'email' && $VARS{'emailid'} ne undef;
    my ($oper, $val) = (split(/:/, $filter{$fields[$i]}));
    my $selector = operselector("f_$fields[$i]_oper", $oper);
    bodyprint("<tr><td>$names[$i]:</td><td>$selector</td><td>");
    if ($fields[$i] eq 'verified') {
      bodyprint("&nbsp;<input type=\"hidden\" name=\"f_$fields[$i]_val\" value=0.5>");
    } elsif ($fields[$i] eq 'status') {
      bodyprint("&nbsp;<input type=\"hidden\" name=\"f_$fields[$i]_val\" value=0.5>");
    } else {
      bodyprint("<input type=\"text\" name=\"f_$fields[$i]_val\" size=\"25\" value=\"$val\">");
    }
    bodyprint("</td></tr>\n");
  }
  for ($i=0; $i < 10; $i++) {
    next if $VARS{"custom$i"} eq undef;
    my ($oper, $val) = (split(/:/, $filter{"custom$i"}));
    my $selector = operselector("f_custom$i"."_oper", $oper);
    bodyprint("<tr><td>".$VARS{"custom$i"}.":</td><td>$selector</td><td><input type=\"text\" name=\"f_custom$i"."_val\" size=\"25\" value=\"$val\"></td></tr>\n");
  }
  bodyprint("<tr><td></td><td><br><br><input type=\"submit\" value=\"Set Filter\"></form></td>\n");
  bodyprint("<td><br><br><form method=\"POST\" action=\"$cgiurl\"><input type=\"hidden\" name=\"cmd\" value=\"setfilter\">\n");
  bodyprint("<input type=\"hidden\" name=\"sid\" value=\"$sid\"><input type=\"hidden\" name=\"user\" value=\"$user\">\n");
  bodyprint("<input type=\"submit\" value=\"Remove Filter\"></form></td></tr>\n");
  bodyprint("</table></center>\n\n");
  &footer;
}
#============================================================================ massmail

sub massmail {
  if ($USRMODE{$user} eq 'O' || $USRMODE{$user} eq 'B') { accmgr(); return; }
  header();
  if ($VARS{'demo'} ne undef) {
    cfrmpage("Mass Mail feature disabled in Demo Mode", 'LIST', 'NEW', 'VIEW', 'STAT', 'LSUBS', 'EDIT', 'DEL', 'BILL', 'RCPT');
    footer();
    return;
  }
  if ($INPUT{'from'} eq undef) {
    formmassmail("Missing sender address");
    return;
  }
  if ($INPUT{'testmail'} ne undef) {
    my $message;
    my @buff = split(/\n/, $INPUT{'msg'});
    foreach my $l (@buff) {
      $l =~ s/\*CORPNAME\*/$VARS{'payname'}/g;
      $l =~ s/\*CORPEMAIL\*/$VARS{'payemail'}/g;
      $message .= "$l\n";
    }
    $message .= "\n\n";
    if ($INPUT{'html'} eq undef) {
      if (open(MAIL, "|$VARS{'mailer'} -t")) {
        print MAIL "To: $INPUT{'from'}\n";
        print MAIL "From: $INPUT{'from'}\n";
        print MAIL "Subject: $INPUT{'subject'}\n\n";
        print MAIL $message;
        close(MAIL);
        formmassmail("The message was sent to $INPUT{'from'}, check your mailbox");
      } else {
        formmassmail("Fatal error: failed to start mailer program $VARS{'mailer'}");
      }
      return;
    } else {
       HTMLMailer::mail($VARS{'mailer'},$INPUT{'from'},$INPUT{'from'},$INPUT{'subject'},$message);
       formmassmail("The message was sent to $INPUT{'from'}, check your mailbox");
       return;
    }
  }
  if (!accutil::massmail($INPUT{'subject'}, $INPUT{'msg'}, $INPUT{'view'}, $INPUT{'from'}, $INPUT{'html'})) {
    errorpage(accutil::error());
    footer();
    return;
  }
  cfrmpage("Mass Mail feature is not supported in LITE version, no mail sent.", 'LIST', 'NEW', 'VIEW', 'STAT', 'LSUBS', 'EDIT', 'DEL', 'BILL', 'RCPT');
  footer();
}
#============================================================================ formmassmail

sub formmassmail {
  &header;
  my $filterset = "&nbsp;";
  if ($USRMODE{$user} eq 'O' || $USRMODE{$user} eq 'B') { accmgr(); return; }
  if ((split(/:/, $INPUT{'view'}))[5] ne undef) { $filterset = "<b>Filter ON</b>"; }
  cmlprint("<form method=\"POST\" action=\"$cgiurl\">\n");
  cmlprint("<input type=\"hidden\" name=\"sid\" value=\"$sid\">");
  cmlprint("<input type=\"hidden\" name=\"user\" value=\"$user\">");
  cmlprint("<input type=\"hidden\" name=\"view\" value=\"$INPUT{'view'}\">");
  cmlprint("<input type=\"image\" name=\"accmgr\" src=\"$VARS{'imgdirurl'}/cmdcancel.gif\" border=\"0\" width=\"50\" height=\"20\" alt=\"Back to accounts list\">");
  stlprint("<table border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\"><tr><td width=\"20%\">$filterset</td><td width=\"60%\">");
  stlprint("<center>Mass Mail</center></td><td width=\"20%\">&nbsp;</td></tr></table>\n\n");
  cmlprint("\n\n");
  bodyprint("</form><br><br><center>\n");
  bodyprint("<font color=red><b>$_[0]<br><br>Mass Mail feature is not supported in LITE version</b><br><br>\n");
  bodyprint("<form method=POST action=\"$cgiurl\">\n");
  bodyprint("<input type=hidden name=cmd value=massmail>\n");
  bodyprint("<input type=hidden name=sid value=$sid>\n");
  bodyprint("<input type=hidden name=user value=\"$user\">\n");
  bodyprint("<input type=hidden name=view value=\"$INPUT{'view'}\">\n");
  $INPUT{'from'} = $VARS{'payemail'} if $INPUT{'from'} eq undef;
  my $msg = $INPUT{'msg'};
  my $ishtml = 'checked' if $INPUT{'html'} ne undef;
  bodyprint("<table><tr><td align=right><b>From:</b></td><td><input type=text name=from size=60 value=\"$INPUT{'from'}\"></td></tr>\n");
  bodyprint("<tr><td align=right><b>Subject:</b></td><td><input type=text name=subject size=60 value=\"$INPUT{'subject'}\"></td></tr>\n");
  bodyprint("<tr><td align=right><b>HTML:</b></td><td><input type=checkbox name=html $ishtml></td></tr>\n");
  bodyprint("<tr><td colspan=2><textarea wrap=\"virtual\" rows=\"20\" cols=\"60\" name=\"msg\">");
  $transparent=1;
  bodyprint($msg);
  $transparent=0;
  bodyprint("</textarea></td></tr>\n");
  bodyprint("<tr><td colspan=2><br><center><input type=\"submit\" value=\"Test\" name=testmail>&nbsp;&nbsp;<input type=\"submit\" value=\"Send Message\"></form></center></td></tr>");
  bodyprint("<tr><td colspan=2>Use:<br><b>*NAME*</b> - to insert customer name<br>");
  bodyprint("<b>*ACCID*</b> - to insert customer id<br>");
  bodyprint("<b>*CUSTOM1*</b> - to insert contents of customer record $VARS{custom1} field<br>");
  bodyprint("<b>*CUSTOM2*</b> - to insert contents of customer record $VARS{custom2} field<br>");
  bodyprint("<b>*CORPNAME*</b> - to insert your company name<br>");
  bodyprint("<b>*CORPEMAIL*</b> - to insert your company email<br>");
  bodyprint("</td></tr></table></center>\n\n");
  &footer;
}
#============================================================================ acctoggle

sub acctoggle {
  &header;
  if ($USRMODE{$user} eq 'O') { accmgr(); return; }
  my %r = accutil::getaccnt($INPUT{'accid'});
  if (!%r) {
    errorpage(accutil::error());
    &footer;
    return;
  }
  my $body = "Dear ";
  if ($r{'name'}.$r{'lname'} ne undef) { $body .= $r{'name'}." ".$r{'lname'}; }
  else { $body .= "Customer"; }
  if (accutil::enabled(%r)) {
    $r{'approved'} = undef;
    $r{'banby'} = $user;
    $r{'banreason'} = $INPUT{'banreason'};
    $r{'banreason'} =~ s/:/ /g;
    $body .= "\n\nYour account with $VARS{'payname'} disabled by system administrator\n" .
             "\nReason: $r{'banreason'}\n\n" .
             "To resolve this issue please contact us ($VARS{'payemail'}) as soon as possible\n\n".
             "Kind regards\n$VARS{'payname'}\n";
  } else {
    $r{'approved'} = $user;
    $r{'openbalance'} = 0;
    $r{'verified'} = 1;
    $r{'banby'} = undef;
    $body .= "\n\nYour account with $VARS{'payname'} activated by system administrator\n" .
             "To review your account settings and access Members Area please login to your account via:\n\n".
             "$VARS{'hostaddr'}$accviewpl\n\n".
             "Kind regards\n$VARS{'payname'}\n";
    unlink("$VARS{'basedir'}/logit/$r{'id'}.txt");
  }
  if (!accutil::editaccnt(%r)) {
      errorpage(accutil::error());
      footer();
      return;
  }
  if ($r{'email'} ne undef) {
    if (open(MAIL, "|$mailer -t")) {
      print MAIL "To: $r{'email'}\n";
      print MAIL "From: \"$VARS{'payname'}\" <$VARS{'payemail'}>\n";
      print MAIL "Subject: Account Notice\n\n";
      print MAIL $body;
      close MAIL;
    }
  }
  $INPUT{'accid'} = $r{'id'};
  cfrmpage("Account $r{'id'} [$r{'name'} $r{'lname'}] updated.", 'LIST', 'NEW', 'VIEW', 'STAT', 'LSUBS', 'EDIT', 'DEL', 'BILL', 'RCPT');
  footer();
}
#============================================================================ formtoggle

sub formtoggle {
  &header;
  if ($USRMODE{$user} eq 'O') { accmgr(); return; }
  my $accid = $INPUT{'accid'};
  if ($accid eq undef) {
    errorpage("No account selected");
    &footer;
    return;
  }
  my %r = accutil::getaccnt($accid);
  if (!%r) {
    errorpage(accutil::error());
    &footer;
    return;
  }
  my ($str, $str1);
  if (accutil::enabled(%r)) { $str = 'Deactivating'; $str1 = 'Deactivate'; }
  else { $str = 'Approving'; $str1 = 'Enable'; }
  cmlprint("<form method=\"POST\" action=\"$cgiurl\">\n");
  cmlprint("<input type=\"hidden\" name=\"sid\" value=\"$sid\">");
  cmlprint("<input type=\"hidden\" name=\"user\" value=\"$user\">");
  cmlprint("<input type=\"hidden\" name=\"view\" value=\"$INPUT{'view'}\">");
  cmlprint("<input type=\"image\" name=\"accmgr\" src=\"$VARS{'imgdirurl'}/cmdcancel.gif\" border=\"0\" width=\"50\" height=\"20\" alt=\"Back to accounts list\">");
  stlprint("<table border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\"><tr><td>");
  stlprint("<center>$str account <font color=red>$accid</font></center></td></tr></table>\n\n");
  cmlprint("\n\n");
  bodyprint("</form><br><br><center><table width=\"50%\">\n");
  bodyprint("<tr><td><form method=\"POST\" action=\"$cgiurl\">\n");
  bodyprint("<input type=\"hidden\" name=\"cmd\" value=\"acctoggle\">\n");
  bodyprint("<input type=\"hidden\" name=\"sid\" value=\"$sid\">\n");
  bodyprint("<input type=\"hidden\" name=\"user\" value=\"$user\">\n");
  bodyprint("<input type=\"hidden\" name=\"accid\" value=\"$accid\">\n");
  bodyprint("<input type=\"hidden\" name=\"view\" value=\"$INPUT{'view'}\">");
  if ($VARS{'emailid'} eq undef) {
    bodyprint("Account ID:</td><td>$accid</td></tr>\n");
  } else {
    bodyprint("&nbsp;</td></tr>\n");
  }
  if ($r{'email'} ne undef) {
   bodyprint("<tr><td>Email Address:</td><td>$r{'email'}");
   if ($r{'verified'}) { bodyprint(" (verified)"); }
   else { bodyprint(" (not verified)"); }
   bodyprint("</td></tr>\n");
  }
  if ($r{'name'}.$r{'lname'} ne undef) {
   bodyprint("<tr><td>Customer name:</td><td>$r{'name'} $r{'lname'}</td></tr>\n");
  }
  bodyprint("<tr><td>Notes</td><td>$r{'notes'}</td></tr>\n") if $r{'notes'} ne undef;
  if ($str1 eq 'Deactivate') {
    bodyprint("<tr><td>Deactivation reason</td><td><input name=banreason type=text size=35></td></tr>\n");
  } elsif ($r{'banby'} ne undef) {
    bodyprint("<tr><td colspan=2><font color=red>Account disabled by $r{'banby'} ($USRNAME{$r{'banby'}})</font><br>Reason: $r{'banreason'}</td></tr>\n");
  }
  bodyprint("</table><br><br><input type=\"submit\" value=\"$str1 Account\"></form><br><br></center>\n\n");
  &footer;
}
#============================================================================ accedit

sub accedit {
  &header;
  if ($USRMODE{$user} eq 'O') { accmgr(); return; }
  my %r = accutil::getaccnt($INPUT{'accid'});
  if (!%r) {
    errorpage(accutil::error());
    &footer;
    return;
  }
  $r{'name'} = $INPUT{'name'};
  $r{'lname'} = $INPUT{'lname'};
  $r{'street'} = $INPUT{'street'};
  $r{'city'} = $INPUT{'city'};
  $r{'state'} = $INPUT{'state'};
  $r{'zip'} = $INPUT{'zip'};
  $r{'country'} = $INPUT{'country'};
  $r{'phone'} = $INPUT{'phone'};
  $r{'fax'} = $INPUT{'fax'};
  for (my $i=0; $i <10; $i++) {
    if ($VARS{"custom$i"."type"} eq 'select' && $INPUT{"custom$i"} eq $plsseltag) {
      $INPUT{"custom$i"} = undef;
    }
    $r{"custom$i"} = $INPUT{"custom$i"};
  }
  $r{'email'} = $INPUT{'email'} if $VARS{'emailid'} eq undef;
  $r{'notes'} = $INPUT{'notes'};
  my $s = $INPUT{'cuspasswd'};
  if ($s ne undef) {
    if (length($s) < 6){
      formeditaccnt("Password must be 6 or more characters");
      return;
    } elsif ($s =~ /\W/) {
      formeditaccnt("Password must contain alphanumeric characters only");
      return;
    } elsif ($s ne $INPUT{'cuspasswd1'}) {
      formeditaccnt("Passwords do not match");
      return;
    }
    $r{'passwd'} = $s;
  }
  if (!accutil::editaccnt(%r)) {
      errorpage(accutil::error());
      footer();
      return;
  }
  $INPUT{'accid'} = $r{'id'};
  cfrmpage("Account $r{'id'} [$r{'name'} $r{'lname'}] updated.", 'LIST', 'NEW', 'VIEW', 'STAT', 'LSUBS', 'EDIT', 'DEL', 'BILL', 'RCPT');
  footer();
}
#============================================================================ accnew

sub accnew {
  &header;
  my %r;
  if ($USRMODE{$user} eq 'O') { accmgr(); return; }
  my $s = $INPUT{'openbalance'};
  my $tm = time();
  srand($tm);
  if ($s eq undef) { $s = int (rand(99999998)+1); }
  $r{'opendate'} = $tm - ($tm % (60 * 60 * 24)) + 1;;
  $r{'openbalance'} = $s;
  $r{'name'} = $INPUT{'name'};
  $r{'lname'} = $INPUT{'lname'};
  $r{'street'} = $INPUT{'street'};
  $r{'city'} = $INPUT{'city'};
  $r{'state'} = $INPUT{'state'};
  $r{'zip'} = $INPUT{'zip'};
  $r{'country'} = $INPUT{'country'};
  $r{'phone'} = $INPUT{'phone'};
  $r{'fax'} = $INPUT{'fax'};
  if ($VARS{'emailid'} eq undef) {
    $r{'email'} = $INPUT{'email'};
  } else {
    $r{'email'} = $INPUT{'newaccid'};
  }
  $r{'notes'} = $INPUT{'notes'};
  for (my $i=0; $i <10; $i++) {
    $r{"custom$i"} = $INPUT{"custom$i"} if $INPUT{"custom$i"} ne $plsseltag;
  }
  $s = $INPUT{'cuspasswd'};
  if ($s eq undef) {
    formnewaccnt("No password provided.");
    return;
  } elsif (length($s) < 6){
    formnewaccnt("Password must be 6 or more characters");
    return;
  } elsif ($s =~ /\W/) {
    formnewaccnt("Password must contain alphanumeric characters only");
    return;
  } elsif ($s ne $INPUT{'cuspasswd1'}) {
    formnewaccnt("Passwords do not match");
    return;
  }
  $r{'passwd'} = $s;
  $s = $INPUT{'newaccid'};
  if ($VARS{'emailid'} ne undef) {
    if ($s eq undef) {
      formnewaccnt("Missing Email Address");
      return;
    }
    if ($s !~ /@/) {
      formnewaccnt("Invalid Email Address");
      return;
    }
  } else {
    if ($s eq undef) {
      $s = accutil::accauto();
      if (!$s) {
        errorpage(accutil::error());
        footer();
        return;
      }
      $s = sprintf("%s%0.6u", $accautoprefix, $s);
    } elsif ($s =~ /^$accautoprefix/) {
      $INPUT{'newaccid'} = undef;
      formnewaccnt("Account ID can't begin with $accautoprefix.");
      return;
    }
  }
  $r{'id'} = $s;
  if (!accutil::addaccnt(%r)) {
      errorpage(accutil::error());
      footer();
      return;
  }
  $INPUT{'accid'} = $r{'id'};
  cfrmpage("New account $r{'id'} [$r{'name'} $r{'lname'}] recorded to database.", 'LIST', 'NEW', 'STAT', 'LSUBS', 'EDIT', 'DEL');
  footer();
}
#============================================================================ formviewaccnt

sub formviewaccnt {
  &header;
  my $accid = $INPUT{'accid'};
  if ($accid eq undef) {
    errorpage("No account selected");
    &footer;
    return;
  }
  my %r = accutil::getaccnt($accid);
  if (!%r) {
    errorpage(accutil::error());
    &footer;
    return;
  }
  cmlprint("<form method=\"POST\" action=\"$cgiurl\">\n");
  cmlprint("<input type=\"hidden\" name=\"sid\" value=\"$sid\">");
  cmlprint("<input type=\"hidden\" name=\"user\" value=\"$user\">");
  cmlprint("<input type=\"hidden\" name=\"view\" value=\"$INPUT{'view'}\">");
  cmlprint("<input type=\"hidden\" name=\"accid\" value=\"$accid\">");
  cmlprint("<input type=\"image\" name=\"accmgr\" src=\"$VARS{'imgdirurl'}/cmdlist.gif\" border=\"0\" width=\"50\" height=\"20\" alt=\"Back to accounts list\">");
  cmlprint("<input type=\"image\" name=\"cmdlog\" src=\"$VARS{'imgdirurl'}/cmdlog.gif\" border=\"0\" width=\"50\" height=\"20\" alt=\"View Log for selected account\">\n");
  if ($USRMODE{$user} ne 'O') {
    cmlprint("<input type=\"image\" name=\"cmdedit\" src=\"$VARS{'imgdirurl'}/cmdedit.gif\" border=\"0\" width=\"50\" height=\"20\" alt=\"Back to accounts list\">");
    cmlprint("<input type=\"image\" name=\"cmddel\" src=\"$VARS{'imgdirurl'}/cmddel.gif\" border=\"0\" width=\"50\" height=\"20\" alt=\"Back to accounts list\">");
    cmlprint("<input type=\"image\" name=\"cmdtoggle\" src=\"$VARS{'imgdirurl'}/cmdtoggle.gif\" border=\"0\" width=\"50\" height=\"20\" alt=\"Toggle membership for selected account\">\n");
  }
  stlprint("<table border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\"><tr><td>");
  stlprint("<center><b>Account $accid</b></center></td></tr></table>\n\n");
  cmlprint("\n\n");
  bodyprint("</form><br><br><center><table width=\"80%\">\n");
  bodyprint("<tr><td width=\"25%\"></td><td></td><td width=\"50%\"></td></tr>");
  bodyprint("<tr><td></td><td><b>Account ID:</b></td><td>$accid</td></tr>\n") if $VARS{'emailid'} eq undef;
  bodyprint("<tr><td></td><td><b>E-mail:</b></td><td><a href=\"mailto:$r{'email'}\">$r{'email'}</a>");
  if ($r{'verified'}) { bodyprint(" (verified)"); }
  else { bodyprint(" (not verified)"); }
  bodyprint("</td></tr>\n");
  if ($r{'banby'} ne undef) {
    bodyprint("<tr><td></td><td colspan=2><font color=red>Account disabled by $r{'banby'}");
    bodyprint(" ($USRNAME{$r{'banby'}})") if $USRNAME{$r{'banby'}} ne undef;
    bodyprint("</font><br><b>Reason:</b> $r{'banreason'}</td></tr>\n");
  }
  bodyprint("<tr><td></td><td><b>Customer password:</b></td><td>$r{'passwd'}</td></tr>\n");
  bodyprint("<tr><td></td><td><b>Name:</b></td><td>$r{'name'} $r{'lname'}</td></tr>\n");
  bodyprint("<tr><td></td><td><b>Address:</b></td><td>");
  if ($cmpladdr) {
    bodyprint("$r{'street'}<br>");
  }
  bodyprint("$r{'city'}<br>$r{'state'} $r{'zip'}<br>$r{'country'}</td></tr>\n");
  if ($cmpladdr) {
    bodyprint("<tr><td></td><td><b>Phone:</b></td><td>$r{'phone'}</td></tr>\n");
    bodyprint("<tr><td></td><td><b>Fax:</b></td><td>$r{'fax'}</td></tr>\n");
  }
  for (my $i = 0; $i <10; $i++) {
    next if $VARS{"custom$i"} eq undef;
    bodyprint("<tr><td></td><td><b>".$VARS{"custom$i"}."</b></td><td>".$r{"custom$i"}."</td></tr>\n");
  }
  bodyprint("<tr><td></td><td><b>Notes</b></td><td>$r{'notes'}</td></tr>\n");
  bodyprint("</table></center>\n\n");
  &footer;
}
#======================================================================= formlog

sub formlog {
  &header;
  my $accid = $INPUT{'accid'};
  if ($accid eq undef) {
    errorpage("No account selected");
    &footer;
    return;
  }
  my %r = accutil::getaccnt($accid);
  if (!%r) {
    errorpage(accutil::error());
    &footer;
    return;
  }
  cmlprint("<form method=\"POST\" action=\"$cgiurl\">\n");
  cmlprint("<input type=\"hidden\" name=\"sid\" value=\"$sid\">");
  cmlprint("<input type=\"hidden\" name=\"user\" value=\"$user\">");
  cmlprint("<input type=\"hidden\" name=\"view\" value=\"$INPUT{'view'}\">");
  cmlprint("<input type=\"hidden\" name=\"accid\" value=\"$accid\">");
  cmlprint("<input type=\"image\" name=\"accmgr\" src=\"$VARS{'imgdirurl'}/cmdlist.gif\" border=\"0\" width=\"50\" height=\"20\" alt=\"Back to accounts list\">");
  cmlprint("<input type=\"image\" name=\"cmdview\" src=\"$VARS{'imgdirurl'}/cmdview.gif\" border=\"0\" width=\"50\" height=\"20\" alt=\"View selected account\">\n");
  if ($USRMODE{$user} ne 'O') {
    cmlprint("<input type=\"image\" name=\"cmdedit\" src=\"$VARS{'imgdirurl'}/cmdedit.gif\" border=\"0\" width=\"50\" height=\"20\" alt=\"Back to accounts list\">");
    cmlprint("<input type=\"image\" name=\"cmddel\" src=\"$VARS{'imgdirurl'}/cmddel.gif\" border=\"0\" width=\"50\" height=\"20\" alt=\"Back to accounts list\">");
    cmlprint("<input type=\"image\" name=\"cmdtoggle\" src=\"$VARS{'imgdirurl'}/cmdtoggle.gif\" border=\"0\" width=\"50\" height=\"20\" alt=\"Toggle membership for selected account\">\n");
  }
  stlprint("<table border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\"><tr><td>");
  stlprint("<center><b>Account $accid</b></center></td></tr></table>\n\n");
  cmlprint("\n\n");
  bodyprint("</form><br><br><center><table width=\"80%\">\n");
  bodyprint("<tr><td width=\"25%\"></td><td></td><td width=\"50%\"></td></tr>");
  bodyprint("<tr><td></td><td><b>Account ID:</b></td><td>$accid</td></tr>\n") if $VARS{'emailid'} eq undef;
  bodyprint("<tr><td></td><td><b>E-mail:</b></td><td><a href=\"mailto:$r{'email'}\">$r{'email'}</a>");
  if ($r{'verified'}) { bodyprint(" (verified)"); }
  else { bodyprint(" (not verified)"); }
  bodyprint("</td></tr>\n");
  if ($r{'banby'} ne undef) {
    bodyprint("<tr><td></td><td colspan=2><font color=red>Account disabled by $r{'banby'}");
    bodyprint(" ($USRNAME{$r{'banby'}})") if $USRNAME{$r{'banby'}} ne undef;
    bodyprint("</font><br><b>Reason:</b> $r{'banreason'}</td></tr>\n");
  }
  bodyprint("<tr><td></td><td><b>Name:</b></td><td>$r{'name'} $r{'lname'}</td></tr>\n") if $r{'name'}.$r{'lname'} ne undef;
  bodyprint("<tr><td></td><td><b>Notes:</b></td><td>$r{'notes'}</td></tr>\n") if $r{'notes'} ne undef;
  my $logfile = "$VARS{'basedir'}/logit/$accid.txt";
  my @last24;
  my @lastmo;
  if (-e $logfile && open(LOG, $logfile)) {
    flock(LOG, $LOCK_EX) if $LOCK_EX;
    my @lines = <LOG>;
    close LOG;
    chomp @lines;
    my $tm = time();
    foreach my $line (@lines) {
      my ($lastseen, $ip) = split(/:/, $line);
      if ($lastseen > $tm - 24*60*60) {
        @last24 = (@last24, $line);
      } elsif ($lastseen > $tm - 30*24*60*60) {
        @lastmo = (@lastmo, $line);
      }
    }
  }
  @last24 = sort(@last24);
  @lastmo = sort(@lastmo);
  bodyprint("<tr><td></td><td colspan=2><center><br><b>Visits last 24 hours</b><hr></td></tr>\n");
  if (!@last24) {
    bodyprint("<tr><td></td><td colspan=2>NO VISITS LOGGED</td></tr>\n");
  } else {
    foreach my $entry (@last24) {
      my ($lastseen, $ip) = split(/:/, $entry);
      my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime($lastseen);
      $mon++; $mon = "0$mon" if $mon < 10; $mday = "0$mday" if $mday < 10;
      $sec = "0$sec" if $sec < 10;
      $min = "0$min" if $min < 10;
      $hour = "0$hour" if $hour < 10;
      $year += 1900;
      bodyprint("<tr><td></td><td colspan=2><tt>$year-$mon-$mday $hour:$min:$sec <b>$ip</b></tt></td></tr>\n");
    }
  }
  bodyprint("<tr><td></td><td colspan=2><center><br><b>Visits last 30 days</b><hr></td></tr>\n");
  if (!@lastmo) {
    bodyprint("<tr><td></td><td colspan=2>NO UNIQUE IP ADDRESSES LOGGED</td></tr>\n");
  } else {
    foreach my $entry (@lastmo) {
      my ($lastseen, $ip) = split(/:/, $entry);
      my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime($lastseen);
      $mon++; $mon = "0$mon" if $mon < 10; $mday = "0$mday" if $mday < 10;
      $sec = "0$sec" if $sec < 10;
      $min = "0$min" if $min < 10;
      $hour = "0$hour" if $hour < 10;
      $year += 1900;
      bodyprint("<tr><td></td><td colspan=2><tt>$year-$mon-$mday $hour:$min:$sec <b>$ip</b></tt></td></tr>\n");
    }
  }
  bodyprint("</table></center>\n\n");
  footer();
}
#============================================================================ formeditaccnt

sub formeditaccnt {
  &header;
  my $msg = $_[0];
  if ($msg ne undef) { $msg = "<font color=red><b>$msg</b></color><br><br>"; }
  if ($USRMODE{$user} eq 'O') { accmgr(); return; }
  my $accid = $INPUT{'accid'};
  if ($accid eq undef) {
    errorpage("No account selected");
    &footer;
    return;
  }
  my %r = accutil::getaccnt($accid);
  if (!%r) {
    errorpage(accutil::error());
    &footer;
    return;
  }
  cmlprint("<form method=\"POST\" action=\"$cgiurl\">\n");
  cmlprint("<input type=\"hidden\" name=\"sid\" value=\"$sid\">");
  cmlprint("<input type=\"hidden\" name=\"user\" value=\"$user\">");
  cmlprint("<input type=\"hidden\" name=\"view\" value=\"$INPUT{'view'}\">");
  cmlprint("<input type=\"image\" name=\"accmgr\" src=\"$VARS{'imgdirurl'}/cmdcancel.gif\" border=\"0\" width=\"50\" height=\"20\" alt=\"Back to accounts list\">");
  stlprint("<table border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\"><tr><td>");
  stlprint("<center><b>Updating an account $accid</b></center></td></tr></table>\n\n");
  cmlprint("\n\n");
  bodyprint("</form><br><br><center>$msg<table width=\"80%\">\n");
  bodyprint("<tr><td width=\"25%\"><form method=\"POST\" action=\"$cgiurl\">\n");
  bodyprint("<input type=\"hidden\" name=\"cmd\" value=\"accedit\">\n");
  bodyprint("<input type=\"hidden\" name=\"sid\" value=\"$sid\">\n");
  bodyprint("<input type=\"hidden\" name=\"user\" value=\"$user\">\n");
  bodyprint("<input type=\"hidden\" name=\"accid\" value=\"$INPUT{'accid'}\">\n");
  bodyprint("<input type=\"hidden\" name=\"view\" value=\"$INPUT{'view'}\"></td>");
  bodyprint("<td></td><td width=\"50%\"></td></tr>");
  my $idtitle = 'Account ID';
  $idtitle = 'Email Address' if $VARS{'emailid'} ne undef;
  bodyprint("<tr><td></td><td><b>$idtitle:</b></td><td>$accid</td></tr>\n");
  bodyprint("<tr><td></td><td colspan=\"2\"><center><hr>Leave password fields blank to preserve current password</center></font></td></tr>\n");
  bodyprint("<tr><td></td><td><b>Customer password:</b></td><td><input type=\"password\" name=\"cuspasswd\" size=\"25\"></td></tr>\n");
  bodyprint("<tr><td></td><td><b>Repeat password:</b></td><td><input type=\"password\" name=\"cuspasswd1\" size=\"25\"></td></tr>\n");
  bodyprint("<tr><td></td><td colspan=\"2\"><center><hr></center></font></td></tr>\n");
  $r{'name'} = $INPUT{'name'} if $INPUT{'name'} ne undef;
  $r{'name'} =~ s/\"/&quot;/g;
  bodyprint("<tr><td></td><td><b>First name:</b></td><td><input type=\"text\" name=\"name\" size=\"25\" value=\"$r{'name'}\"></td></tr>\n");
  $r{'lname'} = $INPUT{'lname'} if $INPUT{'lname'} ne undef;
  $r{'lname'} =~ s/\"/&quot;/g;
  bodyprint("<tr><td></td><td><b>Last name:</b></td><td><input type=\"text\" name=\"lname\" size=\"25\" value=\"$r{'lname'}\"></td></tr>\n");
  if ($VARS{'emailid'} eq undef) {
    $r{'email'} = $INPUT{'email'} if $INPUT{'email'} ne undef;
    bodyprint("<tr><td></td><td><b>E-mail:</b></td><td><input type=\"text\" name=\"email\" size=\"25\" value=\"$r{'email'}\"></td></tr>\n");
  }
  if ($cmpladdr) {
    $r{'street'} = $INPUT{'street'} if $INPUT{'street'} ne undef;
    $r{'street'} =~ s/\"/&quot;/g;
    bodyprint("<tr><td></td><td><b>Street address:</b></td><td><input type=\"text\" name=\"street\" size=\"25\" value=\"$r{'street'}\"></td></tr>\n");
  }
  $r{'city'} = $INPUT{'city'} if $INPUT{'city'} ne undef;
  $r{'city'} =~ s/\"/&quot;/g;
  bodyprint("<tr><td></td><td><b>City:</b></td><td><input type=\"text\" name=\"city\" size=\"25\" value=\"$r{'city'}\"></td></tr>\n");
  $r{'state'} = $INPUT{'state'} if $INPUT{'state'} ne undef;
  $r{'state'} =~ s/\"/&quot;/g;
  bodyprint("<tr><td></td><td><b>State:</b></td><td><input type=\"text\" name=\"state\" size=\"25\" value=\"$r{'state'}\"></td></tr>\n");
  $r{'zip'} = $INPUT{'zip'} if $INPUT{'zip'} ne undef;
  $r{'zip'} =~ s/\"/&quot;/g;
  bodyprint("<tr><td></td><td><b>ZIP:</b></td><td><input type=\"text\" name=\"zip\" size=\"25\" value=\"$r{'zip'}\"></td></tr>\n");
  $r{'country'} = $INPUT{'country'} if $INPUT{'country'} ne undef;
  $r{'country'} =~ s/\"/&quot;/g;
  bodyprint("<tr><td></td><td><b>Country:</b></td><td><input type=\"text\" name=\"country\" size=\"25\" value=\"$r{'country'}\"></td></tr>\n");
  if ($cmpladdr) {
    $r{'phone'} = $INPUT{'phone'} if $INPUT{'phone'} ne undef;
    bodyprint("<tr><td></td><td><b>Phone:</b></td><td><input type=\"text\" name=\"phone\" size=\"25\" value=\"$r{'phone'}\"></td></tr>\n");
    $r{'fax'} = $INPUT{'fax'} if $INPUT{'fax'} ne undef;
    bodyprint("<tr><td></td><td><b>Fax:</b></td><td><input type=\"text\" name=\"fax\" size=\"25\" value=\"$r{'fax'}\"></td></tr>\n");
  }
  for (my $i=0; $i < 10; $i++) {
    next if $VARS{"custom$i"} eq undef;
    bodyprint("<tr><td></td><td><b>".$VARS{"custom$i"}.":</b></td>\n<td>");
    my $type = $VARS{"custom$i"."type"};
    $INPUT{"custom$i"} = $r{"custom$i"} if $INPUT{"custom$i"} eq undef;
    if ($type eq 'select') {
      bodyprint("<select name=custom$i>\n<option>$plsseltag\n");
      my @list = split(/;/,$VARS{"custom$i"."list"});
      foreach my $option (@list) {
        bodyprint("<option");
        bodyprint(" selected") if $INPUT{"custom$i"} eq $option;
        bodyprint(">$option\n");
      }
      bodyprint("</select>\n");
    } elsif ($type eq 'checkbox') {
      my $checked = 'checked' if $INPUT{"custom$i"} ne undef;
      bodyprint("<input type=checkbox name=custom$i $checked>\n");
    } else {
      bodyprint("<input type=text name=custom$i size=25 value=\"".$INPUT{"custom$i"}."\">\n");
    }
    bodyprint("</td></tr>\n");
  }
  $r{'notes'} = $INPUT{'notes'} if $INPUT{'notes'} ne undef;
  bodyprint("<tr><td></td><td><b>Notes</b></td><td><textarea wrap=\"virtual\" rows=\"6\" cols=\"25\" name=\"notes\">$r{'notes'}</textarea></td></tr>\n");
  bodyprint("</table><br><br><input type=\"submit\" value=\"Update Account\"></form></center>\n\n");
  &footer;
}
#============================================================================ formnewaccnt

sub formnewaccnt {
  my $msg = $_[0];
  if ($msg ne undef) { $msg = "<font color=red><b>$msg</b></color><br><br>"; }
  &header;
  if ($USRMODE{$user} eq 'O') { accmgr(); return; }
  cmlprint("<form method=\"POST\" action=\"$cgiurl\">\n");
  cmlprint("<input type=\"hidden\" name=\"sid\" value=\"$sid\">");
  cmlprint("<input type=\"hidden\" name=\"user\" value=\"$user\">");
  cmlprint("<input type=\"hidden\" name=\"view\" value=\"$INPUT{'view'}\">");
  cmlprint("<input type=\"image\" name=\"accmgr\" src=\"$VARS{'imgdirurl'}/cmdcancel.gif\" border=\"0\" width=\"50\" height=\"20\" alt=\"Back to accounts list\">");
  stlprint("<table border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\"><tr><td>");
  stlprint("<center><b>Creating new account</b></center></td></tr></table>\n\n");
  cmlprint("\n\n");
  bodyprint("</form><br><br><center>$msg<table width=\"80%\">\n");
  bodyprint("<tr><td width=\"25%\"<td><form method=\"POST\" action=\"$cgiurl\">\n");
  bodyprint("<input type=\"hidden\" name=\"cmd\" value=\"accnew\">\n");
  bodyprint("<input type=\"hidden\" name=\"sid\" value=\"$sid\">\n");
  bodyprint("<input type=\"hidden\" name=\"user\" value=\"$user\">\n");
  bodyprint("<input type=\"hidden\" name=\"view\" value=\"$INPUT{'view'}\"></td>");
  bodyprint("<td></td><td width=\"50%\"></td></tr>");
  if ($VARS{'emailid'} eq undef) {
    bodyprint("<tr><td></td><td><b>Account ID</b> <i>(leave blank for auto)</i>:</td><td><input type=\"text\" name=\"newaccid\" size=\"25\" value=\"$INPUT{'newaccid'}\"></td></tr>\n");
  } else {
    bodyprint("<tr><td></td><td><b>Email Address:</b></td><td><input type=\"text\" name=\"newaccid\" size=\"25\" value=\"$INPUT{'newaccid'}\"></td></tr>\n");
  }
  my $checkactivate = 'checked' if $INPUT{'openbalance'} ne undef;
  bodyprint("<tr><td></td><td><b>Activate:</b></td><td><input type=\"checkbox\" name=\"openbalance\" value=0 $checkactivate></td></tr>\n");
  bodyprint("<tr><td></td><td><b>Customer password:</b></td><td><input type=\"password\" name=\"cuspasswd\" size=\"25\" value=\"$INPUT{'cuspasswd'}\"></td></tr>\n");
  bodyprint("<tr><td></td><td><b>Repeat password:</b></td><td><input type=\"password\" name=\"cuspasswd1\" size=\"25\"  value=\"$INPUT{'cuspasswd1'}\"></td></tr>\n");
  if ($VARS{'emailid'} eq undef) {
    bodyprint("<tr><td></td><td><b>E-mail:</b></td><td><input type=\"text\" name=\"email\" size=\"25\" value=\"$INPUT{'email'}\"></td></tr>\n");
  }
  bodyprint("<tr><td></td><td><b>First name:</b></td><td><input type=\"text\" name=\"name\" size=\"25\" value=\"$INPUT{'name'}\"></td></tr>\n");
  bodyprint("<tr><td></td><td><b>Last name:</b></td><td><input type=\"text\" name=\"lname\" size=\"25\" value=\"$INPUT{'lname'}\"></td></tr>\n");
  if ($cmpladdr) {
    bodyprint("<tr><td></td><td><b>Street address:</b></td><td><input type=\"text\" name=\"street\" size=\"25\" value=\"$INPUT{'street'}\"></td></tr>\n");
  }
  bodyprint("<tr><td></td><td><b>City:</b></td><td><input type=\"text\" name=\"city\" size=\"25\" value=\"$INPUT{'city'}\"></td></tr>\n");
  bodyprint("<tr><td></td><td><b>State:</b></td><td><input type=\"text\" name=\"state\" size=\"25\" value=\"$INPUT{'state'}\"></td></tr>\n");
  bodyprint("<tr><td></td><td><b>ZIP:</b></td><td><input type=\"text\" name=\"zip\" size=\"25\" value=\"$INPUT{'zip'}\"></td></tr>\n");
  bodyprint("<tr><td></td><td><b>Country:</b></td><td><input type=\"text\" name=\"country\" size=\"25\" value=\"$INPUT{'country'}\"></td></tr>\n");
  if ($cmpladdr) {
    bodyprint("<tr><td></td><td><b>Phone:</b></td><td><input type=\"text\" name=\"phone\" size=\"25\" value=\"$INPUT{'phone'}\"></td></tr>\n");
    bodyprint("<tr><td></td><td><b>Fax:</b></td><td><input type=\"text\" name=\"fax\" size=\"25\" value=\"$INPUT{'fax'}\"></td></tr>\n");
  }
  for (my $i=0; $i < 10; $i++) {
    next if $VARS{"custom$i"} eq undef;
    bodyprint("<tr><td></td><td><b>".$VARS{"custom$i"}.":</b></td>\n<td>");
    my $type = $VARS{"custom$i"."type"};
    if ($type eq 'select') {
      bodyprint("<select name=custom$i>\n<option>$plsseltag\n");
      my @list = split(/;/,$VARS{"custom$i"."list"});
      foreach my $option (@list) {
        bodyprint("<option");
        bodyprint(" selected") if $INPUT{"custom$i"} eq $option;
        bodyprint(">$option\n");
      }
      bodyprint("</select>\n");
    } elsif ($type eq 'checkbox') {
      my $checked = 'checked' if $INPUT{"custom$i"} ne undef;
      bodyprint("<input type=checkbox name=custom$i $checked>\n");
    } else {
      bodyprint("<input type=text name=custom$i size=25 value=\"".$INPUT{"custom$i"}."\">\n");
    }
    bodyprint("</td></tr>\n");
  }
  bodyprint("<tr><td></td><td><b>Notes</b></td><td><textarea wrap=\"virtual\" rows=\"6\" cols=\"25\" name=\"notes\">$INPUT{'notes'}</textarea></td></tr>\n");
  bodyprint("</table><br><br><input type=\"submit\" value=\"Create Account\"></form></center>\n\n");
  &footer;
}
#============================================================================ formdelaccnt

sub formdelaccnt {
  &header;
  if ($USRMODE{$user} eq 'O') { accmgr(); return; }
  my $accid = $INPUT{'accid'};
  if ($accid eq undef) {
    errorpage("No account selected");
    &footer;
    return;
  }
  my %r = accutil::getaccnt($accid);
  if (!%r) {
    errorpage(accutil::error());
    &footer;
    return;
  }
  cmlprint("<form method=\"POST\" action=\"$cgiurl\">\n");
  cmlprint("<input type=\"hidden\" name=\"sid\" value=\"$sid\">");
  cmlprint("<input type=\"hidden\" name=\"user\" value=\"$user\">");
  cmlprint("<input type=\"hidden\" name=\"view\" value=\"$INPUT{'view'}\">");
  cmlprint("<input type=\"image\" name=\"accmgr\" src=\"$VARS{'imgdirurl'}/cmdcancel.gif\" border=\"0\" width=\"50\" height=\"20\" alt=\"Back to accounts list\">");
  stlprint("<table border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\"><tr><td>");
  stlprint("<center>Deleting account <font color=red>$accid</font></center></td></tr></table>\n\n");
  cmlprint("\n\n");
  my $str = $r{'openbalance'};
  if (!$str || $str < 0) { $str = 'Active'; }
  else { $str = 'Inactive'; }
  bodyprint("</form><br><br><center><table width=\"50%\"><tr><td>Status:</td><td><b>$str</b></td></tr>\n");
  bodyprint("<tr><td><form method=\"POST\" action=\"$cgiurl\">\n");
  bodyprint("<input type=\"hidden\" name=\"cmd\" value=\"accdel\">\n");
  bodyprint("<input type=\"hidden\" name=\"sid\" value=\"$sid\">\n");
  bodyprint("<input type=\"hidden\" name=\"user\" value=\"$user\">\n");
  bodyprint("<input type=\"hidden\" name=\"accid\" value=\"$accid\">\n");
  bodyprint("<input type=\"hidden\" name=\"view\" value=\"$INPUT{'view'}\">");
  bodyprint("Account ID:</td><td>$accid</td></tr>\n");
  bodyprint("<tr><td>Customer name:</td><td>$r{'name'} $r{'lname'}</td></tr>\n");
  bodyprint("<tr><td>Notes</td><td>$r{'notes'}</td></tr></table>\n");
  bodyprint("<br><br><input type=\"submit\" value=\"Delete Account\"></form><br><br></center>\n\n");
  &footer;
}

#============================================================================ cfrmpage
# cfrmpage($msg[, $command1, ...])
# does not print header & footer

sub cfrmpage {
  my $msg = shift @_;
  my $command = shift @_;
  cmlprint("<table border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\"><tr>");
  cmlprint("<form method=\"POST\" action=\"$adminpl\"><td width=\"50\" valign=\"top\">");
  cmlprint("<input type=\"hidden\" name=\"sid\" value=\"$sid\">");
  cmlprint("<input type=\"hidden\" name=\"user\" value=\"$user\">");
  cmlprint("<input type=\"image\" name=\"cmdadmin\" src=\"$VARS{'imgdirurl'}/cmdadmin.gif\" border=\"0\" width=\"50\" height=\"20\" alt=\"Manage users and products\"></td></form>\n");
  cmlprint("<form method=\"POST\" action=\"$cgiurl\"><td>");
  cmlprint("<input type=\"hidden\" name=\"sid\" value=\"$sid\">");
  cmlprint("<input type=\"hidden\" name=\"user\" value=\"$user\">");
  cmlprint("<input type=\"hidden\" name=\"view\" value=\"$INPUT{'view'}\">");
  cmlprint("<input type=\"hidden\" name=\"accid\" value=\"$INPUT{'accid'}\">");
  while($command ne undef) {
    if ($command eq 'VIEW') {
      cmlprint("<input type=\"image\" name=\"cmdview\" src=\"$VARS{'imgdirurl'}/cmdview.gif\" border=\"0\" width=\"50\" height=\"20\" alt=\"View account details\">");
    }
    if ($command eq 'LIST') {
      cmlprint("<input type=\"image\" name=\"accmgr\" src=\"$VARS{'imgdirurl'}/cmdlist.gif\" border=\"0\" width=\"50\" height=\"20\" alt=\"Back to accounts list\">");
    }
    if ($command eq 'LSUBS') {
      cmlprint("<input type=\"image\" name=\"cmdtoggle\" src=\"$VARS{'imgdirurl'}/cmdtoggle.gif\" border=\"0\" width=\"50\" height=\"20\" alt=\"Toggle membership for selected account\">\n");
    }
    if ($command eq 'LOG') {
      cmlprint("<input type=\"image\" name=\"cmdlog\" src=\"$VARS{'imgdirurl'}/cmdlog.gif\" border=\"0\" width=\"50\" height=\"20\" alt=\"View Log for selected account\">\n");
    }
    if ($USRMODE{$user} ne 'O') {
      if ($command eq 'NEW') {
        cmlprint("<input type=\"image\" name=\"cmdnew\" src=\"$VARS{'imgdirurl'}/cmdnew.gif\" border=\"0\" width=\"50\" height=\"20\" alt=\"Add new account\">\n");
      }
      if ($command eq 'DEL') {
        cmlprint("<input type=\"image\" name=\"cmddel\" src=\"$VARS{'imgdirurl'}/cmddel.gif\" border=\"0\" width=\"50\" height=\"20\" alt=\"Delete selected account\">\n");
      }
    }
    $command = shift @_;
  }
  stlprint("<table border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\"><tr><td>");
  stlprint("<center><b>Confirmation</b></center></td></tr></table>\n\n");
  cmlprint("</td><td width=\"50\" valign=\"top\"><input type=\"image\" name=\"cmdlogoff\" src=\"$VARS{'imgdirurl'}/cmdlogoff.gif\" width=\"50\" height=\"20\" alt=\"Logoff\"></td>\n");
  cmlprint("</tr></table>\n\n");
  bodyprint("</form><br><br><center><b>$msg</b></center><br><br>\n\n");
}
#============================================================================ errorpage
# errorpage($err)
# does not print header & footer

sub errorpage {
  my $e = $_[0];
  cmlprint("<form method=\"POST\" action=\"$cgiurl\">\n");
  cmlprint("<input type=\"hidden\" name=\"sid\" value=\"$sid\">");
  cmlprint("<input type=\"hidden\" name=\"user\" value=\"$user\">");
  cmlprint("<input type=\"hidden\" name=\"view\" value=\"$INPUT{'view'}\">");
  cmlprint("<input type=\"image\" name=\"accmgr\" src=\"$VARS{'imgdirurl'}/cmdcancel.gif\" border=\"0\" width=\"50\" height=\"20\" alt=\"Back to accounts list\">");
  stlprint("<table border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\"><tr><td>");
  stlprint("<center><font color=red><b>Error</b></font></center></td></tr></table>\n\n");
  cmlprint("\n\n");
  bodyprint("</form><br><br><center><b>Error: $e</b></center><br><br>\n\n");
}
#============================================================================ accmgr

sub accmgr {
  my $view = $INPUT{'view'};
  my $skip = $INPUT{'skip'};
  my ($total, @fields);
  my $step = $INPUT{'step'};
  my $filterset = "&nbsp;";
  if ($step eq undef) { $step = $initstep; }
  my ($s, $s1, $str);
  &header;
  if ($view eq undef) {
    my %filter;
    $skip = 0;
    $view = &accutil::createview('and', %filter);
    my @fields = split(/:/, $view);
    $total = shift @fields;
    if ($total < 0) {
      my $e = &accutil::error;
      print "<p><b>Error: $e<b><p>\n";
      return;
    }
  } elsif ($skip eq undef) { ($skip) = (split(/:/, $view))[2]; }
  if ((split(/:/, $view))[5] ne undef) { $filterset = "<b>Filter ON</b>"; }
  $view = accutil::readview($view, $skip, $step);
  ($total) = (split(/:/, $view))[0];
  if ($total < 0) {
    my $e = &accutil::error;
    stlprint("<font color=red>Internal Error</font>\n\n");
    cmlprint("\n\n");
    bodyprint("<p><b>Error: $e<b><p>\n");
    &footer;
    return;
  }
  my $cnt = accutil::viewcnt();
  if (!$cnt) {
    $skip = $total - $step;
    if ($skip < 0) { $skip = 0; }
    $view = &accutil::readview($view, $skip, $step);
    $cnt = accutil::viewcnt();
    @fields = split(/:/, $view);
    $total = shift @fields;
    if ($total < 0) {
      my $e = &accutil::error;
      stlprint("<font color=red>Internal Error</font>\n\n");
      cmlprint("\n\n");
      bodyprint("<p><b>Error: $e<b><p>\n");
      &footer;
      return;
    }
  }
  bodyprint("<table border=\"1\" cellspacing=\"0\" width=\"100%\">");
  if ($VARS{'emailid'} eq undef) {
    bodyprint("<tr><td><b>&nbsp;ID</b></td>");
  } else {
    bodyprint("<tr><td><b>&nbsp;Email Address</b></td>");
  }
  bodyprint("<td><b>Name</b></td>");
  bodyprint("<td><b>City</b></td>");
  bodyprint("<td><b>State</b></td>");
  bodyprint("<td><b>Country</b></td>");
  if ($VARS{'emailid'} eq undef) {
    bodyprint("<td><b>Email</b></td>");
  }
  bodyprint("<td><b>Active</b></td></tr>\n");
  my $n;
  for ($n = $cnt; $n; $n--) {
    my %r = &accutil::nextrec;
    bodyprint("<tr>\n");
    if ($VARS{'emailid'} eq undef) {
      bodyprint("<td><input type=\"radio\" name=\"accid\" value=\"$r{'id'}\">$r{'id'}</td>\n");
    } else {
        $str = "<a href=\"mailto:$r{'id'}\">$r{'id'}</a>";
        if ($r{'verified'}) { $str .= "</td><td align=right><small><b>[V]</b><small>"; }
        else { $str .= "</td><td align=right><small><b>[NV]</b></small>"; }
        bodyprint("<td><table border=0 cellspacing=0 cellpadding=0 width=\"100%\"><tr>\n".
                  "<td align=left><input type=\"radio\" name=\"accid\" value=\"$r{'id'}\">\n$str</td></tr></table></td>\n");
    }
    $str = "$r{'name'} $r{'lname'}";
    if ($str eq ' ') { $str = "&nbsp;"; }
    bodyprint("<td>$str</td>");
    $str = "$r{'city'}";
    if ($str eq undef) { $str = "&nbsp;"; }
    bodyprint("<td>$str</td>");
    $str = "$r{'state'}";
    if ($str eq undef) { $str = "&nbsp;"; }
    bodyprint("<td>$str</td>");
    $str = "$r{'country'}";
    if ($str eq undef) { $str = "&nbsp;"; }
    bodyprint("<td>$str</td>");
    if ($VARS{'emailid'} eq undef) {
      if ($r{'email'} eq undef) { bodyprint("<td>&nbsp;</td>\n"); }
      else {
        $str = "<a href=\"mailto:$r{'email'}\">$r{'email'}</a>";
        if ($r{'verified'}) { $str .= "</td><td align=right><small><b>[V]</b><small>"; }
        else { $str .= "</td><td align=right><small><b>[NV]</b></small>"; }
        bodyprint("<td><table border=0 cellspacing=0 cellpadding=0 width=\"100%\"><tr><td align=left>$str</td></tr></table></td>\n");
      }
    }
    if (accutil::enabled(%r)) { $str = 'Yes'; }
    else { $str = 'No'; }
    bodyprint("<td>$str</td>");
    bodyprint("</tr>\n");
  }
  bodyprint("</table>\n");
  stlprint("<table border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\"><tr><td width=\"20%\">$filterset</font></td>");
  cmlprint("<table border=\"0\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\"><tr>");
  cmlprint("<form method=\"POST\" action=\"$adminpl\"><td width=\"50\" valign=\"top\">");
  cmlprint("<input type=\"hidden\" name=\"sid\" value=\"$sid\">");
  cmlprint("<input type=\"hidden\" name=\"user\" value=\"$user\">");
  cmlprint("<input type=\"image\" name=\"cmdadmin\" src=\"$VARS{'imgdirurl'}/cmdadmin.gif\" width=\"50\" height=\"20\" border=\"0\" alt=\"Manage users and products\"></td></form>\n");
  cmlprint("<form method=\"POST\" action=\"$cgiurl\"><td>");
  cmlprint("<input type=\"hidden\" name=\"sid\" value=\"$sid\">");
  cmlprint("<input type=\"hidden\" name=\"user\" value=\"$user\">");
  cmlprint("<input type=\"hidden\" name=\"view\" value=\"$view\">");
  cmlprint("<input type=\"image\" name=\"cmdview\" src=\"$VARS{'imgdirurl'}/cmdview.gif\" border=\"0\" width=\"50\" height=\"20\" alt=\"View selected account\">\n");
  cmlprint("<input type=\"image\" name=\"cmdlog\" src=\"$VARS{'imgdirurl'}/cmdlog.gif\" border=\"0\" width=\"50\" height=\"20\" alt=\"View Log for selected account\">\n");
  if ($USRMODE{$user} eq 'A' || $USRMODE{$user} eq 'S') {
      cmlprint("<input type=\"image\" name=\"cmdmail\" src=\"$VARS{'imgdirurl'}/cmdmail.gif\" border=\"0\" width=\"50\" height=\"20\" alt=\"Mass Mail\">\n");
  }
  if ($USRMODE{$user} ne 'O') {
      cmlprint("<input type=\"image\" name=\"cmdtoggle\" src=\"$VARS{'imgdirurl'}/cmdtoggle.gif\" border=\"0\" width=\"50\" height=\"20\" alt=\"Toggle selected account on/off\">\n");
      cmlprint("<input type=\"image\" name=\"cmdnew\" src=\"$VARS{'imgdirurl'}/cmdnew.gif\" border=\"0\" width=\"50\" height=\"20\" alt=\"Add new account\">\n");
      cmlprint("<input type=\"image\" name=\"cmdedit\" src=\"$VARS{'imgdirurl'}/cmdedit.gif\" border=\"0\" width=\"50\" height=\"20\" alt=\"Edit selected account\">\n");
      cmlprint("<input type=\"image\" name=\"cmddel\" src=\"$VARS{'imgdirurl'}/cmddel.gif\" border=\"0\" width=\"50\" height=\"20\" alt=\"Delete selected account\">\n");
  }
  cmlprint("<input type=\"image\" name=\"cmdfilter\" src=\"$VARS{'imgdirurl'}/cmdfilter.gif\" border=\"0\" width=\"50\" height=\"20\" alt=\"Set/clear filter\">\n");
  if ($skip){
    if ($skip < $step) { $s=0; $str="First $skip"; }
    else { $s=$skip-$step; $str="Prev $step"; }
    cmlprint("<input type=\"hidden\" name=\"skipb\" value=\"$s\">");
    cmlprint("<input type=\"hidden\" name=\"stepb\" value=\"$step\">");
    cmlprint("<input type=\"image\" name=\"accmgrb\" src=\"$VARS{'imgdirurl'}/cmdprev.gif\" alt=\"$str\" border=\"0\" width=\"50\" height=\"20\">");
  } else { cmlprint("<img src=\"$VARS{'imgdirurl'}/cmdprevgr.gif\" width=\"50\" height=\"20\">"); }
  $s = $skip + 1;
  if (!$total) { $s = 0; }
  $s1 = $skip + $cnt;
  stlprint("<td><center>Accounts $s-$s1 out of $total selected</center></td>");
  $skip = $skip + $cnt;
  if ($skip < $total) {
    $s1 = $total - $skip;
    if ($s1 > $step) { $str = "Next $step"; }
    else { $str = "Last $s1"; }
    cmlprint("<input type=\"hidden\" name=\"skipf\" value=\"$skip\">");
    cmlprint("<input type=\"hidden\" name=\"stepf\" value=\"$step\">");
    cmlprint("<input type=\"image\" src=\"$VARS{'imgdirurl'}/cmdnext.gif\" name=\"accmgrf\"alt=\"$str\" border=\"0\" width=\"50\" height=\"20\">");
  } else { cmlprint("<img src=\"$VARS{'imgdirurl'}/cmdnextgr.gif\" width=\"50\" height=\"20\">"); }
  stlprint("<td width=\"20%\">&nbsp;</td></tr></table>\n\n");
  cmlprint("</td><td width=\"50\" valign=\"top\"><input type=\"image\" name=\"cmdlogoff\" border=\"0\" src=\"$VARS{'imgdirurl'}/cmdlogoff.gif\" width=\"50\" height=\"20\" alt=\"Logoff\"></td>\n");
  cmlprint("</tr></table>\n\n");
  bodyprint("</td></tr></table></form>\n\n");
  &footer;
}
#============================================================================ accdel

sub accdel {
  &header;
  if ($USRMODE{$user} eq 'O') { &accmgr; return; }
  my $id = $INPUT{'accid'};
  if (!accutil::delaccnt($id)) { errorpage(accutil::error()); }
  else { cfrmpage("Account <font color=red>$id</font> deleted.\n", 'LIST'); }
  &footer;
}
#============================================================================ checksid

sub checksid {
  if ($sid eq $USRSID{$user}) { return 1; }
  return 0;
}
#============================================================================ bodyprint

sub bodyprint {
  my $line = $_[0];
  $line =~ s/\<td/<td bgcolor=\"$VARS{'bodycolor'}\" valign=\"top\"/g if !$transparent;
  if (!@bodylines) {
    push @bodylines, "<tr><td bgcolor=\"$VARS{'bodycolor'}\">";
  }
  push @bodylines, $line;
  if ($line =~ /\n\n/) {
    while (@bodylines) { print shift @bodylines; }
    print "</td></tr>";
  }
}

#============================================================================ cmlprint

sub cmlprint {
  my $line = $_[0];
  $line =~ s/\<td/<td bgcolor=\"$VARS{'cmdcolor'}\"/g;
   if (!@cmdline) {
    push @cmdline, "<tr><td bgcolor=\"$VARS{'cmdcolor'}\">";
  }
  push @cmdline, $line;
  if ($line =~ /\n\n/) {
    while (@cmdline) { print shift @cmdline; }
    print "</td></tr>";
  }
}
#============================================================================ stlprint

sub stlprint {
  my $line = $_[0];
  $line =~ s/\<td/<td bgcolor=\"$VARS{'stlcolor'}\"/g;
  if (!@statusline) {
    push @statusline, "<tr><td bgcolor=\"$VARS{'stlcolor'}\">";
  }
  push @statusline, $line;
  if ($line =~ /\n\n/) {
    while (@statusline) { print shift @statusline; }
    print "</td></tr>";
  }
}
#============================================================================ header

sub header {
if ($headeron) { return; }
print<<EOF;
<HTML>\n
<HEAD><TITLE>Account Manager</TITLE>
<link rel=stylesheet href=$VARS{'imgdirurl'}/styles.css type=text/css>
</HEAD>\n
<body bgcolor="$VARS{'bodycolor'}">
<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"760\"><tr><td>
<table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">
EOF
$headeron=1;
my $header_file = "$basedir/tmpl/header.txt";
if (-e $header_file) {
        if (open(HDR, "<$header_file")) {
                my @lines = <HDR>;
                close(HDR);
                print "<tr><td>\n";
                print @lines;
                return;
                print "</td></tr>\n";
        }
}
  if ($singleuser eq 'on') {
    print "<tr><td><br><center><font color=\"red\"><b>**** SINGLE USER MODE ****</b></font></center><br><br></td></tr>\n";
  }
}

#============================================================================ footer

sub footer {
my $footer_file = "$basedir/tmpl/footer.txt";
if ($debug) {
  print "<tr><td>";
  my $tm = time() - $starttime;
  my ($utm, $stm) = (times())[0, 1];
  print "Run time = $tm, user = $utm, system = $stm</br>";
  foreach my $key (sort keys (%INPUT)) {
    print "$key: $INPUT{$key}<br>\n";
  }
  print "<p>VARS:</br>\n";
  foreach my $key (sort keys (%VARS)) {
    print "$key: $VARS{$key}<br>\n";
  }
  accutil::debug();
  print "</td></tr>";
}
if (-e $footer_file) {
        if (open(FTR, "<$footer_file")) {
                my @lines = <FTR>;
                close(FTR);
                print "<tr><td>\n";
                print @lines;
                print "<p><font size=-2>RegisterMe! (c) - 2000-02, <a href=\"http://www.eastwright.com/internet/\">Eastwright Corp.</font></a><br>";
                print "</td></tr></td></tr></table></td></tr></table></BODY></HTML>\n";
                return;
        }
} else {
  print "<tr><td><br><table width=\"100%\" border=0><tr><td><hr></td></tr><tr><td>";
  print "<p><p><font size=-2>RegisterMe! (c) - 2000-02, <a href=\"http://www.eastwright.com/internet/\">Eastwright Corp.</a><br>";
  print "Support: <A HREF=\"mailto:$adminemail\">$adminemail</A><br>";
  print "Version: $version $package";
  print "</font></td></tr></table></td></tr></table></td></tr></table></BODY></HTML>\n";
}
}

#============================================================================ formpwd

sub formpwd {
  my $usrid = $INPUT{'usrid'};
  my $p;
  &header;
  if ($user eq $USRPWD{$user}) {
    print "<font size=+1 color=red><b>Your password match your user id. You must change your password</b></font><p>\n";
    $usrid = $user;
    $p = $user;
  }
print <<EOT;
Change password for user <b>$usrid</b><p>
<table border=0><tr><td>
<form method="POST" action="$adminpl">
<input type="hidden" name="cmd" value="pwdupd">
<input type="hidden" name="sid" value="$sid">
<input type="hidden" name="user" value="$user">
<input type="hidden" name="usrid" value="$usrid">
Current password:</td><td><input type="password" size="10" name="passwd" value="$p";></td></tr>
<tr><td>New password:</td><td><input type="password" size="10" name="newpwd"></td></tr>
<tr><td>Re-enter new password:</td><td><input type="password" size="10" name="newpwd1"></td>
</table><br>
<input type="submit" value="Set password"></form><p>
EOT
  &footer;
}
#============================================================================ login

sub login {
  if ($singleuser eq 'on' && $USRMODE{$user} ne 'A') {
    loginform("Database shot down for maintenance, please try login later");
    return;
  }
  my $p = $INPUT{'passwd'};
  my $p1 = $USRPWD{$user};
  if ($p1 eq undef || ($p ne $p1)) {
    loginform("Wrong password");
    return;
  }
  srand(time());
  $sid = int rand(1000000);
  $USRSID{$user} = $sid;
  savepwd();
  if ($user eq $p) { formpwd(); }
  else { if ($VARS{'version'} < 3) { upgrform(); return; } accmgr(); }
}
#============================================================================ loginform

sub loginform {
  my $msg = $_[0];
  if ($msg ne undef) { $msg = "<font color=red><b>$msg</b></color><br><br>"; }
  &header;
  stlprint("<center>Account Manager Login</center>\n\n");
  cmlprint("&nbsp;\n\n");
  bodyprint("<center><br><br>$msg<table><tr><td><form method=\"POST\" action=\"$cgiurl\">");
  bodyprint("<b>User:</font></b></td><td><input type=\"text\" size=\"10\" name=\"user\"></td></tr>");
  bodyprint("<td><b>Password:</td><td><input type=\"password\" size=\"10\" name=\"passwd\"></td></tr>");
  bodyprint("<tr><td><input type=\"hidden\" name=\"cmd\" value=\"login\"></td><td>");
  bodyprint("<input type=\"submit\" value=\"Login\"></form></td></tr></table>\n\n");
  &footer;
}
#============================================================================ errexit

sub errexit {
print <<EOT;
<html><head></head><body>
<center><br><font size=+1 color=red><b>
Fatal Error: $_[0]. Execution aborted...
</b></font></center>
</body></html>
EOT
exit;
}
#============================================================================ savepwd

sub savepwd {
  my $key;
  if (!open(PWD, ">$pwdfile")) { &errexit("Failed to open passwords file for update"); }
  flock(PWD, $LOCK_EX) if $LOCK_EX;
  foreach $key (keys (%USRPWD)) {
      print PWD "$key:$USRPWD{$key}:$USRMODE{$key}:$USRSID{$key}:$USRMAIL{$key}:$USRPHONE{$key}:$USRNAME{$key}\n";
  }
  close (PWD);
}
#============================================================================ logoff

sub logoff {
  $USRSID{$user} = undef;
  savepwd();
  loginform();
}
#============================================================================ loadpwd

sub loadpwd {
  my @buff;
  my $line;
  if (!open(PWD, $pwdfile)) { return 0; }
  flock(PWD, $LOCK_EX) if $LOCK_EX;
  @buff = <PWD>;
  close (PWD);
  chomp(@buff);
  foreach $line (@buff) {
    my $name; my $passwd; my $rights; my $s; my $m; my $p; my $n;
    ($name, $passwd, $rights, $s, $m, $p, $n) = split(/:/, $line);
    if ($name) {
      $USRPWD{$name} = $passwd;
      $USRMODE{$name} = $rights;
      $USRSID{$name} = $s;
      $USRMAIL{$name} = $m;
      $USRPHONE{$name} = $p;
      $USRNAME{$name} = $n;
    }
  }
  return 1;
}
#============================================================================ findcgidir

sub findcgidir {
  my $scriptfilename = $ENV{'SCRIPT_FILENAME'};
  $scriptfilename = $ENV{'PATH_TRANSLATED'} if $ENV{'PATH_TRANSLATED'} ne undef;
  if ($scriptfilename eq undef) {
    if ($ENV{'PWD'} ne undef) {
      my @parts = split(/\//, $ENV{'SCRIPT_NAME'});
      my $f = pop @parts;
      $scriptfilename = "$ENV{'PWD'}/$f";
    }
  }
  my @cgipath = split(/\//, $scriptfilename);
  pop(@cgipath);
  $cgidir = join("\/", @cgipath);
}
#============================================================================ loadcgf

sub loadcfg {
  my @buff;
  my $line;
  if (! open(CFG, $cfgfile)) { return 0; }
  @buff = <CFG>;
  close(CFG);
  chomp(@buff);
  foreach $line (@buff) {
    my $name;
    my $value;
    ($name, $value) = split(/=/, $line);
    if ($value ne undef) { $VARS{$name} = $value; }
  }
  $basedir = $VARS{'basedir'};
  $accviewpl = $VARS{'accview'};
  $adminpl = $VARS{'admin'};
  $adminemail = $VARS{'adminemail'};
  $mailer = $VARS{'mailer'};
  $pwdfile = $VARS{'pwdfile'};
  $uselock = $VARS{'uselock'};
  $singleuser = $VARS{'singleuser'};
  $cmpladdr = $VARS{'cmpladdr'};
  $reqemail = $VARS{'reqemail'};
  $VARS{'custom1'} = 'Custom 1' if $VARS{'custom1'} eq undef;
  $VARS{'custom2'} = 'Custom 2' if $VARS{'custom2'} eq undef;
  $VARS{'bodycolor'} = '#fcfceb' if $VARS{'bodycolor'} eq undef;
  $VARS{'cmdcolor'} = '#b5cc94' if $VARS{'cmdcolor'} eq undef;
  $VARS{'stlcolor'} = '#fff0cf' if $VARS{'stlcolor'} eq undef;
  &accutil::init(%VARS);
  if ($uselock) { $LOCK_EX = "2"; }
  if (!loadpwd()) { return 0; }
  return 1;
}